//===================================================================
//
// reno_general.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

void led_control(void *payload)
{
	switch (((UINT8*)payload)[0])
	{
		case 'r':
			led_on(1);
			break;
		case 'R':			
			led_off(1);
			break;
		case 'g':
			led_on(2);
			break;
		case 'G':	
			led_off(2);
			break;
		case 'y':
			led_on(3);
			break;
		case 'Y':
			led_off(3);
			break;
		default:
			led_off(1);
			led_off(2);
			led_off(3);
			break;
	}
}


// TX thread 
void task1(void* args)
{
	UINT8 dest_id, data_length;
	INT8 data[NWK_MAX_PAYLOAD_SIZE]; //108
	INT16 *integer;
	INT8 tmp_str[10];
	integer =(INT16*) data;
		
	while (TRUE)
	{
		//---------------- String sends--------------
		uart_printf("\nInput destination ID(0~255) : ");
		uart_gets(data, 4); // 3 character + '\0' character.
		dest_id = atoi(data);

		// Receive string from keyboard.
		uart_printf("\nType message, and then press 'Enter'.\n");
		uart_gets(data, NWK_MAX_PAYLOAD_SIZE);
		nwk_tx(dest_id, strlen(data)+1, data);	// string length = string + '\0' 


		//---------------- INT16 sends----------------
		uart_printf("\nInput destination ID(0~255) : ");
		uart_gets(data, 4); // 3 character + '\0' character.
		dest_id = atoi(data);

		// Receive INT16s from keyboard.
		data_length=0;
		uart_printf("\nType INT16, and then press 'Enter' in sequence.\nTo terminate input, type 'e'.\n");
		while(data_length < NWK_MAX_PAYLOAD_SIZE/sizeof(INT16))
		{
			uart_gets(tmp_str, 7); // >= 6 character + '\0'
			if (tmp_str[0] == 'e' && tmp_str[1] == '\0' )
			{
				uart_puts("Send? (y/n) : ");
				uart_gets(&tmp_str[2], 2);
				if ( tmp_str[2] == 'y' )
					break;
			}
			else
			{
				integer[data_length] = atoi (tmp_str);
				data_length++;
			}
		}
		data_length*= sizeof(INT16); // each data is 2byte
		uart_puts("Sending...");
		print_payload(-16, data_length, integer); // print as (INT16)
		uart_puts("\r\n");		
		nwk_tx(dest_id, data_length, integer );
	}
}

// RX thread
void task2(void* args)
{
	UINT8 src_id;
	UINT8 length;
	INT8 data[128];
	while (TRUE)
	{
		if ( nwk_rx(&src_id, &length, data) )
		{
			//print_nib();		// my seqence number print
			//print_route_table();	// routing table print
			// If data is received, application can use this data
			print_payload(0, length, data);	// string print
			print_payload(-16, length, data);	// INT16 print
			//print_payload(8, length, data);		//UINT8
			//print_payload(-8, length, data);	//INT8
			//print_payload(16, length, data);	//UINT16
			uart_puts("\r\n\n");
#ifdef LED_M
			led_control(data);
#endif
		}
	}
}

int main(void) 
{
	UINT8 	channel = 0x0C;
	UINT8 	node_id = 1;
	UINT8 	min_permit_id = 0; 
	UINT8 	max_permit_id = 255;
	UINT16 	pan_id = 312;

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Configuration
	INT8 tmp[10];
	do
	{
		uart_puts("\r\nEnter my RF Channel (11~26): ");
		uart_gets(tmp, 3);
		channel = atoi(tmp);
	}while (!( atoi(tmp) >= 11  && atoi(tmp) <=26 ));
	do
	{
		uart_puts("\rEnter my PAN ID (0~65534): ");
		uart_gets(tmp, 6);
		pan_id = atol(tmp);
	}while (!( atol(tmp) >= 0  && atol(tmp) <=65535 ));
	do
	{
		uart_puts("\rEnter my id (0~255): ");
		uart_gets(tmp, 4);
		node_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));
	uart_printf("\nThe range of receivable node id\n");
	do
	{
		uart_puts("\rMin (0~255): ");
		uart_gets(tmp, 4);
		min_permit_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));
	do
	{
		uart_puts("\rMax (0~255): ");
		uart_gets(tmp, 4);
		max_permit_id = atoi(tmp);
	}while (!( atoi(tmp) >= 0  && atoi(tmp) <=255 ));

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]	
	nwk_init(channel, pan_id, node_id, min_permit_id, max_permit_id);

 	uart_printf("\n\nRF Channel : %d \nPAN address: %u \nID : %d \nReceivable Range : %d ~ %d\n", channel, pan_id, node_id, min_permit_id, max_permit_id);

	thread_create(1, task1, NULL, 138, PRIORITY_NORMAL);
	thread_create(2, task2, NULL, 138, PRIORITY_NORMAL);

 	sched_start();

	return 0;
} // main
