//===================================================================
//
// reno_us.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

//------ Change here for testing ----------//
#define CHANNEL 12
#define PAN_ADDR 312
#define MY_ID 12
#define DEST_ID 11
//------ Change here for testing ----------//








// US RX interrupt handler, TX the battery power and the distance.
void us_int_handler(void)
{
	UINT16 data[2];
	data[0] = us_get_data();
	data[1] = 'd';	// distance
	uart_printf("\nDistance : %u cm", data[0]);
	nwk_tx(DEST_ID, 4, data);
	data[0] = bat_get_data();
	data[1] = 'b';	// battery
	nwk_tx(DEST_ID, 4, data);
}


// US triggering thread 
void task1(void* args)
{
	while (TRUE)
	{
		uart_printf("\nTriggering..\n");		
		us_trigger();
		thread_sleep_ms(500);
	}
}

// RX thread
void task2(void* args)
{
	UINT8 src_id;
	UINT8 length;
	UINT8 data[128];
	while (TRUE)
	{
		if ( nwk_rx(&src_id, &length, data) )
		{
			if ( ((UINT16*)data)[1] == 'd' )
			{
				uart_printf("\n\tReceived Distance : %ucm", ((UINT16*)data)[0]);
			}
			else
			{
				uart_printf("\n\r\tRecieved Battery : %d.%d%dV", ((UINT16*)data)[0]/100, (((UINT16*)data)[0]%100)/10, (((UINT16*)data)[0]%100)%10);
			}
		}
	}
}

int main(void) 
{
	UINT8 	channel = CHANNEL;
	UINT8 	node_id = MY_ID; 
	UINT16 	pan_id = PAN_ADDR;
	UINT8 	min_permit_id = 0; 
	UINT8 	max_permit_id = 255;
//--------for simulation--------------------
//	min_permit_id = (node_id/10-1)*10;
//	max_permit_id = (node_id/10+1)*10+9;
//---------------------------------------

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN ID : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]	
	nwk_init(channel, pan_id, node_id, min_permit_id, max_permit_id);
 	uart_printf("\r\n\nRF Channel : %d PAN : %d ID : %d Receivable Range : %d ~ %d\n", channel, pan_id, node_id, min_permit_id, max_permit_id);
	us_power_on();	// power on PIR SENSOR sensor 
	us_callback(us_int_handler);
	
	thread_create(1, task1, NULL, 4, PRIORITY_NORMAL);
	thread_create(2, task2, NULL, 128, PRIORITY_NORMAL);
 	sched_start();

	us_power_off(); // power off PIR SENSOR sensor 
	return 0;
} // main
