//===================================================================
//
// sequence.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "nos.h"

int main(void) 
{	
	UINT16 temperature;

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");
	
	temp_power_on(); // power on TEMP sensor
	light_power_on(); // power on LIGHT sensor
	gas_power_on();; // power on GAS sensor
	hum_power_on(); // power on HUM sensor
	
	while (1)
	{

		temperature = temp_get_data();
		uart_printf("Current Temperature : %d.%d\n", temperature/10, temperature%10);
		uart_printf("Current Brightness of Light : %u lux\n", light_get_data());
		uart_printf("Current Density of Gas : %uppm\n", gas_get_data());
		uart_printf("Current Humidity : RH %u%%\n", hum_get_data());

		uart_printf("\n"); // line spacing
		delay_ms(1000); // Do sensing every 1 second		
	}

	temp_power_off(); // power off TEMP sensor 
	light_power_off(); // power off LIGHT sensor 
	gas_power_off(); // power off GAS sensor 
	hum_power_off(); // power off HUM sensor 
	
	return 0;
} // main
