//========================================================================
// File		: thread_stk1.c 
// Author	: sheart@etri.re.kr, haekim@etri.re.kr
// Date		: 2006
// Description : 
//========================================================================
// Copyright 2004-2010, ETRI
//========================================================================
#include "nos.h"

void task1(void *args)
{
	INT16 temperature;
	while (1)
	{
		temperature = temp_get_data();
		uart_printf("Current Temperature : %d.%d\n", temperature/10, temperature%10);
		thread_sleep_ms(1000); // Do sensing every 1 second
	}
}

void task2(void *args)
{
	while (1)
	{
		uart_printf("Current Brightness of Light : %u lux\n", light_get_data());
		thread_sleep_ms(1000); // Do sensing every 1 second
	}
}

void task3(void *args)
{
	while (1)
	{
		uart_printf("Current Density of Gas : %uppm\n", gas_get_data());
		thread_sleep_ms(1000); // Do sensing every 1 second
	}
}

void task4(void *args)
{
	while (1)
	{
		uart_printf("Current Humidity : RH %u%%\n", hum_get_data());
		thread_sleep_ms(1000); // Do sensing every 1 second
	}
}

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	temp_power_on(); // power on TEMP sensor
        light_power_on(); // power on LIGHT sensor
        gas_power_on();; // power on GAS sensor
        hum_power_on(); // power on HUM sensor

	uart_printf("=== Thread test for 4 Sensors ===\n");
	thread_create(1, task1, NULL, 0, PRIORITY_NORMAL); 	
	thread_create(2, task2, NULL, 0, PRIORITY_NORMAL); 
	thread_create(3, task3, NULL, 0, PRIORITY_NORMAL);
	thread_create(4, task4, NULL, 0, PRIORITY_NORMAL);

	sched_start(); 

	temp_power_off(); // power off TEMP sensor                        
	light_power_off(); // power off LIGHT sensor 
	gas_power_off(); // power off GAS sensor 
       hum_power_off(); // power off HUM sensor 

   	return 0;
}
