//===================================================================
//
// rx.c (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "nos.h"

NMAC_RX_INFO rx_info;
UINT8 rx_payload[NMAC_MAX_PAYLOAD_SIZE];

void read_frame(void)
{
	mac_rx(&rx_info);
	uart_putu(rx_payload[0]);
	uart_putc('\n');
 }

int main (void)
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	rx_info.payload_ptr = rx_payload;

	mac_init(0x11, 0x2420, 0x5678); // channel=26, PAN id = 0x2420, node id = 0x5678 (B)
	mac_set_rx_cb( read_frame );	// default : NULL, sets a callback function for RX interrupt

   	while (TRUE) 
	{
		;
	}
    return 0;
}
