//===================================================================
//
// sender11.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

UINT8 tx_data[NWK_MAX_PAYLOAD_SIZE]; //109, actually you need only 2 byte for this appl.
UINT8 data[NWK_MAX_PAYLOAD_SIZE];
	
void led_control(void *payload)
{
	switch (((UINT8*)payload)[0])
	{
		case '1':
			led_toggle(1);
			break;
		case '2':
			led_toggle(2);
			break;
		case '3':
			led_toggle(3);
			break;
		default:
			led_off(1);
			led_off(2);
			led_off(3);
			break;
	}
}


// TX thread : sends "r" to node 31 every about 0.5sec
void task1(void* args)
{
	UINT8 dest_id, data_length;

	dest_id = 31;
	tx_data[0]='2';
	tx_data[1]= '\0';
	data_length = 2;			

	while (TRUE)
	{
		print_local_clock();
		nwk_tx(dest_id, data_length, tx_data);
		thread_sleep_ms(200);
	}
}

//Receives string and toggles LEDs.
void rx_callback(void)
{
	UINT8 src_id;
	UINT8 length;

	while ( nwk_rx(&src_id, &length, data) )
	{
		print_route_table();
		print_payload(0, 2, data);
		led_control(data);
	}
}

int main(void) 
{
	UINT8 channel = 26;
	UINT16 pan_addr  = 312;	
	UINT8 node_id = 11;	
//--------for multi-hop test ----------------
	UINT8 min_permit_id = 0;
	UINT8 max_permit_id = 29;
//---------------------------------------


	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN addr : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]
	nwk_init(channel, pan_addr, node_id, min_permit_id, max_permit_id);
	nwk_set_rx_cb(rx_callback);

	uart_printf("RF Channel : %d\nPAN address: %u\nID : %d\nReceivable Range : %d ~ %d\n", 
				channel, pan_addr, node_id, min_permit_id, max_permit_id);

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);

 	sched_start();

	return 0;
} // main
