//===================================================================
//
// sink1.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include "nos.h"

#define MY_ID			1
#define MIN_PERMIT_ID	0
#define MAX_PERMIT_ID	19
#define CHANNEL		26
#define PAN_ADDR	312
#define TX_SLEEP_PERIOD	3000

UINT8 data[NWK_MAX_PAYLOAD_SIZE];
UINT8 rx_data[NWK_MAX_PAYLOAD_SIZE];
UINT8 src_id;
UINT8 length;


//Receives string and toggles LEDs.
void rx_callback(void)
{
	while ( nwk_rx(&src_id, &length, rx_data) )
	{
		led_toggle(3);
		uart_printf("\nRX : from node %d", src_id);
	}
}

void task1(void* args)
{
	UINT8 i, data_length;
	for (i =0; i<NWK_MAX_PAYLOAD_SIZE; ++i)
	{
		data[i]=i;		// dummy data
	}
	data_length = 1;
	
	while (TRUE)
	{
		print_route_table();
		thread_sleep_sec(30);

		/*
		led_toggle(2);	
		nwk_tx(10, data_length, data);
		print_route_table();
		thread_sleep_ms(TX_SLEEP_PERIOD);
		*/

	}
}

int main(void) 
{
	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	// Initializing  [ Channel:0x0B~0x1A (11~26), PAN addr : 0x0000~0xfffE(0~65534), Node ID(MAC short address) : 0~255 ]
	nwk_init(CHANNEL, PAN_ADDR, MY_ID, MIN_PERMIT_ID, MAX_PERMIT_ID);
	nwk_set_rx_cb(rx_callback);

	uart_printf("RF Channel : %d\nPAN address: %u\nID : %d\nReceivable Range : %d ~ %d\n", 
				CHANNEL, PAN_ADDR, MY_ID, MIN_PERMIT_ID, MAX_PERMIT_ID);

	thread_create(task1, NULL, 0, PRIORITY_NORMAL);

 	sched_start();

	return 0;
} // main
