//===================================================================
//
// teno_debug_node.c (@haekim)                                                               
//
//===================================================================           
// Copyright 2004-2010, ETRI 
//===================================================================
#include <stdlib.h>

#include "nos.h"


#define CHANNEL		26
#define PAN_ADDR	312

int main(void) 
{
	UINT16 	my_addr, mac_dest;
	UINT8 msg_type;
	INT8 tmp[10];
	TENO_DATA_PACKET pdata;
	pdata.msg_type=TENO_UPDATA;
	pdata.msg_hop_limit = 30;
	pdata.msg_hop_count = 0;
	pdata.port = 1;
	pdata.payload_size = 1;
	pdata.payload_ptr = tmp;

	

	nos_init();
	led_on(1);
	uart_puts("\n\r*** Nano OS ***\n\r");

	while(1)
	{
		// Configuration
		do
		{
			uart_puts("\n\n\rEnter my ID: ");
			uart_gets(tmp, 6);
			my_addr = atoi(tmp);
		}while (!( my_addr >= 0  && my_addr <= 65534 ));

		teno_init(CHANNEL, PAN_ADDR, my_addr);
		teno_role_as_sink();
		nmac_rx_off();
		uart_printf("RF Channel : %d\nPAN address: %u\nID : %d\n", 
					CHANNEL, PAN_ADDR, my_addr);
		pdata.src_id = teno_nib.my_id;

		do
		{
			uart_puts("\rMessage type(1:JOIN, 2:REPLY, 3:RELEASE, 4:DATA):");
			uart_gets(tmp, 2);
			msg_type = atoi(tmp);
		}while (!( msg_type >= 1  && msg_type <=4 ));

		if (msg_type == 1)
		{
			uart_puts("\r[JOIN]my depth: ");
			uart_gets(tmp, 6);
			teno_nib.my_depth = atoi(tmp);
			teno_send_join_to_mac();
		}
		else if (msg_type == 2)
		{
			uart_puts("\r[REPLY]Next Hop (MAC destination): ");
			uart_gets(tmp, 6);
			mac_dest = atoi(tmp);
			uart_puts("\r[REPLY]my depth: ");
			uart_gets(tmp, 6);
			teno_nib.my_depth = atoi(tmp);
			teno_send_reply_to_mac(mac_dest);
		}
		else if (msg_type == 3)
		{
			uart_puts("\r[RELEASE]Next Hop (MAC destination): ");
			uart_gets(tmp, 6);
			mac_dest = atoi(tmp);
			teno_send_release_to_mac(mac_dest);
		}
		else if (msg_type == 4)
		{
			uart_puts("\r[DATA]Next Hop (MAC destination): ");
			uart_gets(tmp, 6);
			mac_dest = atoi(tmp);
			uart_puts("\r[DATA]my depth: ");
			uart_gets(tmp, 6);
			teno_nib.my_depth = atoi(tmp);
			uart_puts("\r[DATA]my sink ID: ");
			uart_gets(tmp, 6);
			pdata.dest_id = atoi(tmp);
			teno_send_data_to_mac(&pdata, mac_dest);
		}
		
	}

	return 0;
} // main
