//########################################################
//
// hal.h (@ybpark)
//
//########################################################
// Copyright 2008-2014, HCI Lab
//########################################################

#ifndef HAL_H
#define HAL_H
#include "kconf.h"
#include "typedef.h"

//#ifdef HAL_M

#define HIGH			2
#define LOW				1
#define NONE			255

#define PORT_A			0x00
#define PORT_B			0x10
#define PORT_C			0x20
#define PORT_D			0x30
#define PORT_E			0x40
#define PORT_F			0x60
#define PORT_G			0x70
#define PORT_NONE		0xF0

#define PIN_0			0x00
#define PIN_1			0x01
#define PIN_2			0x02
#define PIN_3			0x03
#define PIN_4			0x04
#define PIN_5			0x05
#define PIN_6			0x06
#define PIN_7			0x07

#define INT_GENERAL_IN	0
#define INT_GENERAL_OUT	1
#define INT_ADC			2
#define INT_INTERRUPT	3
#define INT_I2C			4
#define INT_FREQUENCY	5
#define INT_SPI			6

#define LOGICAL_LEVEL	0
#define FALLING_EDGE	2
#define RISING_EDGE		3

//write()  ڵ鿡 ü
typedef union {
	UINT8 enable_state;
	void (*int_callback_func)(void);
}WRITE_ARGV;
	
//mapping table
typedef struct infoPowPort{
	UINT8 port;
	UINT8 enable;
}InfoPowPort;

typedef struct infoDataPort{
	UINT8 type;
	UINT8 port[4];
}InfoDataPort;

typedef struct mappingTable{
	INT8* dev_name;
	InfoPowPort powPort;
	InfoDataPort dataPort;
}MappingTable;

INT8* hal_get_dev_name(UINT8 fd);
// ********************************************************************************
//                                               power port   Լ
// ********************************************************************************

// power port   Ѵ.
// ȯ      0 ȯ ϰ 
//       1 ȯ Ѵ.
//power port ׻   Ѵ.
UINT8 hal_pport_init(UINT8 fd);
//   ΰ Ѵ.
//  ΰϴ Ʈ ° ÷ ڰ 
//  ־ ϱ⶧ ϵ  ̺  ϰ ִ´.
// ȯ   ᰡ 1̴.
UINT8 hal_pport_on(UINT8 fd);
//   .
//  ΰϴ Ʈ ° ÷ ڰ 
//  ־ ϱ⶧ ϵ  ̺  ϰ ִ´.
// ȯ   ᰡ 1̴.
UINT8 hal_pport_off(UINT8 fd);

#ifdef ADC_M
// ********************************************************************************
//                                               ADC   Լ
// ********************************************************************************
// adc ʱȭ Ѵ. 
// NanoQplus  ʱȭ Լ Ѵ.
void hal_adc_init(void);
// adc value ȯѴ.
//   ϶ 0xFFFF ȯ Ѵ.
// ATmega128 10bit register ⶧ 0xFFFF  ʴ´.
UINT16 hal_get_adc_data(UINT8 fd);
#endif

#ifdef INTERRUPT_M
// ********************************************************************************
//                                               INTERRUPT   Լ
// ********************************************************************************
// interrupt  
// interrupt port  ߸ Ǿ  1 ȯѴ.
UINT8 hal_interrupt_mask_setting(UINT8 fd);
// interrupt Ȱ ¸ Ѵ.
// fd value state  Ѱ ش.
// state  LOGICAL_LEVEL, FALLING_EDGE, RISING_EDGE ϳ   Ѵ.
// ȯ   ϶ 1 ȯѴ.
UINT8 hal_interrupt_enable_state_setting(UINT8 fd, UINT8 state);
// ͷƮ  ƾ Ѵ.
// fd, callback function pointer Ѱش.
//   ϶ 1 ȯѴ.
UINT8 hal_register_interrupt_callback_func(UINT8 fd, void (*func)(void));
#endif

#ifdef I2C_M
// ********************************************************************************
//                                               I2C   Լ
// ********************************************************************************
#define I2C_SCK		0
#define I2C_DATA	1
// i2c ̽ SCK ʱȭ Ѵ.
// Ŭ ׻ Ϳ  ֱ⶧   Ѵ.
//  ̺ ε 0 SCK   Ѵ. 
// ȯ   ϶ 1 ȯ Ѵ.
UINT8 hal_i2c_sck_port_init(UINT8 fd);
// i2c ̽ DATA  ʱȭ Ѵ.
// DATA  Է°    ؾ ϸ
//       ϱ Ͽ   Ѵ.
//  ̺ ε 1 DATA   Ѵ. 
// ȯ   ϶ 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_output(UINT8 fd);
// i2c ̽ DATA Է ʱȭ Ѵ.
// DATA  Է°    ؾ ϸ
//       ϱ Ͽ Է  Ѵ.
//  ̺ ε 1 DATA   Ѵ. 
// ȯ   ϶ 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_input(UINT8 fd);
// sckɿ high ȣ ϴ Լ̴.
UINT8 hal_i2c_sck_port_high(UINT8 fd);
// sckɿ low ȣ ϴ Լ̴.
UINT8 hal_i2c_sck_port_low(UINT8 fd);
// data ɿ high    ϴ Լ̴.
//  ϱ   Ʈ Է Ǿ   1 ȯ Ѵ. 
//  ̺ ̺  ߸ Ǿ  쵵 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_high(UINT8 fd);
// data ɿ low    ϴ Լ̴.
//  ϱ   Ʈ Է Ǿ   1 ȯ Ѵ. 
//  ̺ ̺  ߸ Ǿ  쵵 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_low(UINT8 fd);
// data  Է° Ȯϴ Լ̴.
//   Ǿ ְų 
//  ̺ ̺  ߸ Ǿ  쵵 0xFF ȯ Ѵ.
UINT8 hal_i2c_data_port_read_bit(UINT8 fd);
#endif

#endif // ~HAL_H
