//===================================================================
//
// adc.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "adc.h"

#ifdef ADC_M
#include <avr/io.h>
#include "critical_section.h"

void nos_adc_init()
{
	////////////////////////// ADCSRA REGISTER Setting
	// ADEN(1) : ADC Enable
	// ADPS(011) : ADC Prescaler Selection Bits (Division Factor = 8)
	ADCSRA = (1 << ADPS1) | (1 << ADPS0) | (1 << ADEN);
	
	////////////////////////// ADMUX REGISTER Setting
	// REFS(11) : Internal 2.56V reference with external capacitor at AREF pin
	// ADLAR(0) : Diable ADC Left Adjust Result
	ADMUX = (1 << REFS1) | (1 << REFS0) | (0 << ADLAR);
}

// channel : TEMP_SENSOR, LIGHT_SENSOR, GAS_SENSOR, BAT_SENSOR
UINT16 nos_adc_convert(UINT8 adc_channel)
{
	UINT16 adc_result;
NOS_ENTER_CRITICAL_SECTION();
	ADMUX = (1 << REFS1) | (1 << REFS0) | (0 << ADLAR) | (0x1f & adc_channel);
	// start of conversion
	ADCSRA |= (1 << ADSC);
        	
	// wait until the conversion completes
	while (!(ADCSRA & (1 << ADIF)));
       	
	// 10 bit data mode (8 bit data mode is not supported)
	// Converted values are lied on ADCH:ADCL
 	// To combine these two bytes into 16bit, 2^8 = 256 need to be multiplied
 	adc_result = ADC;
NOS_EXIT_CRITICAL_SECTION();
	return(adc_result);
}

#endif //ADC_M 
