//===================================================================
//
// eeprom.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
//#include <avr/interrupt.h>
#include <avr/io.h>

#include "eeprom.h"

#ifdef EEPROM_M

void nos_eeprom_write_byte(UINT16 addr, UINT8 byte)
{
	// wait until write operation is completed
	while (EECR & (1 << EEWE));

	// setting for address and data registers
	EEAR = addr;
	EEDR = byte;

	// write enable
	EECR |= (1 << EEMWE);
	
	// begin to write by using EEWE
	EECR |= (1 << EEWE);
}

UINT8 nos_eeprom_read_byte(UINT16 addr)
{
	// wait until write operation is completed
	while (EECR & (1 << EEWE));

	// setting for address and data registers
	EEAR = addr;
	
	// begin to read by using EERE
	EECR |= (1 << EERE);
	
	// read byte from data register
	return EEDR;
}


void nos_eeprom_write_block(const UINT16 addr, const INT8 *buf, UINT16 len)
{
	UINT16 i;

	for ( i = 0; i < len; ++i )
		nos_eeprom_write_byte(addr + i, buf[i]);
}

void nos_eeprom_read_block(UINT16 addr, INT8 *buf, UINT16 len)
{
	UINT16 i;
	
	for ( i = 0; i < len; ++i )
		buf[i] = nos_eeprom_read_byte(addr + i);
}
#endif	// EEPROM_M
