//########################################################
//
// hal.c (@ybpark)
//
//########################################################
// Copyright 2008-2014, HCI Lab
//########################################################
#include "hal.h"

#ifdef HAL_M

#include "uart.h"
#include "platform.h"

#ifdef INTERRUPT_M
#include "intr.h"
#include <avr/interrupt.h>
#include "critical_section.h"

static void (*callback_func[8])(void);

#endif
MappingTable* nos_mappingTable = NULL;

INT8* hal_get_dev_name(UINT8 fd)
{
	return (nos_mappingTable+fd)->dev_name;
}

// ********************************************************************************
//                                               power port   Լ
// ********************************************************************************

// power port   Ѵ.
// ȯ      0 ȯ ϰ 
//       1 ȯ Ѵ.
//power port ׻   Ѵ.
UINT8 hal_pport_init(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
	case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

//   ΰ Ѵ.
//  ΰϴ Ʈ ° ÷ ڰ 
//  ־ ϱ⶧ ϵ  ̺  ϰ ִ´.
// ȯ   ᰡ 1̴.
UINT8 hal_pport_on(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	if((nos_mappingTable+fd)->powPort.enable == HIGH)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == LOW)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0) {
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == NONE)
	{
	}
	else 
	{
		return 1;
	}
	return 0;
}

//   .
//  ΰϴ Ʈ ° ÷ ڰ 
//  ־ ϱ⶧ ϵ  ̺  ϰ ִ´.
// ȯ   ᰡ 1̴.
UINT8 hal_pport_off(UINT8 fd)
{
	if(nos_mappingTable == NULL)
	{
		return 1;
	}
	
	if((nos_mappingTable+fd)->powPort.enable == HIGH)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0) {
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == LOW)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == NONE)
	{
	}
	else 
	{
		return 1;
	}
	return 0;
}

#ifdef ADC_M
// ********************************************************************************
//                                               ADC   Լ
// ********************************************************************************

// adc ʱȭ Ѵ. 
// NanoQplus  ʱȭ Լ Ѵ.
void hal_adc_init(void)
{
	nos_adc_init();

	return;
}

// adc value ȯѴ.
//   ϶ 0xFFFF ȯ Ѵ.
// ATmega128 10bit register ⶧ 0xFFFF  ʴ´.
UINT16 hal_get_adc_data(UINT8 fd)
{
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0) != PORT_F)
		return 0xFFFF;
	
	return nos_adc_convert(((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
}
#endif

#ifdef INTERRUPT_M
// ********************************************************************************
//                                               INTERRUPT   Լ
// ********************************************************************************

// interrupt  
// interrupt port  ߸ Ǿ  1 ȯѴ.
UINT8 hal_interrupt_mask_setting(UINT8 fd)
{
	switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
	case PORT_D: 
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
		case PIN_0: CLEAR_INT0_vect(); ENABLE_INT0_vect(); break;
		case PIN_1: CLEAR_INT1_vect(); ENABLE_INT1_vect(); break;
		case PIN_2: CLEAR_INT2_vect(); ENABLE_INT2_vect(); break;
		case PIN_3: CLEAR_INT3_vect(); ENABLE_INT3_vect(); break;
		default : return 1;
		}
		break;
	case PORT_E: 
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
		case PIN_4: CLEAR_INT4_vect(); ENABLE_INT4_vect(); break;
		case PIN_5: CLEAR_INT5_vect(); ENABLE_INT5_vect(); break;
		case PIN_6: CLEAR_INT6_vect(); ENABLE_INT6_vect(); break;
		case PIN_7: CLEAR_INT7_vect(); ENABLE_INT7_vect(); break;
		default : return 1;
		}
		break;
	}
	return 0;
}

// interrupt Ȱ ¸ Ѵ.
// fd value state  Ѱ ش.
// state  LOGICAL_LEVEL, FALLING_EDGE, RISING_EDGE ϳ   Ѵ.
// ȯ   ϶ 1 ȯѴ.
UINT8 hal_interrupt_enable_state_setting(UINT8 fd, UINT8 state)
{
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_D 
		&& ((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_E)
		return 1;
	if(!(state == LOGICAL_LEVEL || state == FALLING_EDGE || state == RISING_EDGE))
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
	case PIN_0: EICRA |= state << 0; break;
	case PIN_1: EICRA |= state << 2; break;
	case PIN_2: EICRA |= state << 4; break;
	case PIN_3: EICRA |= state << 6; break;
	case PIN_4: EICRB |= state << 0; break;
	case PIN_5: EICRB |= state << 2; break;
	case PIN_6: EICRB |= state << 4; break;
	case PIN_7: EICRB |= state << 6; break;
	default : return 1;
	}
	
	return 0;
}

// ͷƮ  ƾ Ѵ.
// fd, callback function pointer Ѱش.
//   ϶ 1 ȯѴ.
UINT8 hal_register_interrupt_callback_func(UINT8 fd, void (*func)(void))
{
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_D 
		&& ((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_E)
		return 1;

	callback_func[((nos_mappingTable+fd)->dataPort.port[0] & 0x0F)] = func;
	
	return 0;
}

// interrupt service routine
ISR(INT0_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[0])
		callback_func[0]();
	NOS_EXIT_ISR();
}    
ISR(INT1_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[1])
		callback_func[1]();
	NOS_EXIT_ISR();
}    

ISR(INT2_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[2])
		callback_func[2]();
	NOS_EXIT_ISR();
}    

ISR(INT3_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[3])
		callback_func[3]();
	NOS_EXIT_ISR();
}    

ISR(INT4_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[4])
		callback_func[4]();
	NOS_EXIT_ISR();
}    

ISR(INT5_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[5])
		callback_func[5]();
	NOS_EXIT_ISR();
}    

ISR(INT6_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[6])
		callback_func[6]();
	NOS_EXIT_ISR();
}    

ISR(INT7_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[7])
		callback_func[7]();
	NOS_EXIT_ISR();
}    
#endif

#ifdef I2C_M

// ********************************************************************************
//                                               I2C   Լ
// ********************************************************************************

// i2c ̽ SCK ʱȭ Ѵ.
// Ŭ ׻ Ϳ  ֱ⶧   Ѵ.
//  ̺ ε 0 SCK   Ѵ. 
// ȯ   ϶ 1 ȯ Ѵ.
UINT8 hal_i2c_sck_port_init(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0xF0)	{
	case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

// i2c ̽ DATA  ʱȭ Ѵ.
// DATA  Է°    ؾ ϸ
//       ϱ Ͽ   Ѵ.
//  ̺ ε 1 DATA   Ѵ. 
// ȯ   ϶ 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_output(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0xF0)	{
	case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

// i2c ̽ DATA Է ʱȭ Ѵ.
// DATA  Է°    ؾ ϸ
//       ϱ Ͽ Է  Ѵ.
//  ̺ ε 1 DATA   Ѵ. 
// ȯ   ϶ 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_input(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0xF0)	{
	case PORT_A: _BIT_CLR(DDRA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_B: _BIT_CLR(DDRB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_C: _BIT_CLR(DDRC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_D: _BIT_CLR(DDRD,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_E: _BIT_CLR(DDRE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_F: _BIT_CLR(DDRF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_G: _BIT_CLR(DDRG,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

// sckɿ high ȣ ϴ Լ̴.
UINT8 hal_i2c_sck_port_high(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0xF0)	{
	case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

// sckɿ low ȣ ϴ Լ̴.
UINT8 hal_i2c_sck_port_low(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0xF0)	{
	case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->dataPort.port[I2C_SCK] & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

// data ɿ high    ϴ Լ̴.
//  ϱ   Ʈ Է Ǿ   1 ȯ Ѵ. 
//  ̺ ̺  ߸ Ǿ  쵵 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_high(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	UINT8 state = 0;
	switch((nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0xF0)	{
	case PORT_A: state = _IS_SET(DDRA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F);
					_BIT_SET(PORTA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_B: state = _IS_SET(DDRB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_SET(PORTB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_C: state = _IS_SET(DDRC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_SET(PORTC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_D: state = _IS_SET(DDRD,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_SET(PORTD,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_E: state = _IS_SET(DDRE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_SET(PORTE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_F: state = _IS_SET(DDRF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_SET(PORTF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_G: state = _IS_SET(DDRG,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_SET(PORTG,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_NONE: state = 1; break;
	default : return 1;
	}

	if(state == 0)
		return 1;
	return 0;
}

// data ɿ low    ϴ Լ̴.
//  ϱ   Ʈ Է Ǿ   1 ȯ Ѵ. 
//  ̺ ̺  ߸ Ǿ  쵵 1 ȯ Ѵ.
UINT8 hal_i2c_data_port_low(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	UINT8 state = 0;
	switch((nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0xF0)	{
	case PORT_A: state = _IS_SET(DDRA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F);
					_BIT_CLR(PORTA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_B: state = _IS_SET(DDRB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_CLR(PORTB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_C: state = _IS_SET(DDRC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_CLR(PORTC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_D: state = _IS_SET(DDRD,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_CLR(PORTD,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_E: state = _IS_SET(DDRE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_CLR(PORTE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_F: state = _IS_SET(DDRF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_CLR(PORTF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_G: state = _IS_SET(DDRG,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); 
					_BIT_CLR(PORTG,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_NONE: state = 1; break;
	default : return 1;
	}

	if(state == 0)
		return 1;
	return 0;
}

// data  Է° Ȯϴ Լ̴.
//   Ǿ ְų 
//  ̺ ̺  ߸ Ǿ  쵵 0xFF ȯ Ѵ.
UINT8 hal_i2c_data_port_read_bit(UINT8 fd)
{
	UINT8 return_value;
	if(nos_mappingTable == NULL)
		return_value = 0x00;
	
	switch((nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0xF0)	{
	case PORT_A: return_value = _IS_SET(PINA,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_B: return_value = _IS_SET(PINB,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_C: return_value = _IS_SET(PINC,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_D: return_value = _IS_SET(PIND,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_E: return_value = _IS_SET(PINE,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_F: return_value = _IS_SET(PINF,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	case PORT_G: return_value = _IS_SET(PING,(nos_mappingTable+fd)->dataPort.port[I2C_DATA] & 0x0F); break;
	default : return_value = 0x00; break;
	}

	return !!return_value;
}
#endif

#endif

/*//########################################################
//
// hal.c (@ybpark)
//
//########################################################
// Copyright 2008-2014, HCI Lab
//########################################################
#include "hal.h"

#ifdef HAL_M

#ifdef UART_M
#include "uart.h"
#include "intr.h"
#include "platform.h"
#endif

#include "intr.h"
#include <avr/interrupt.h>
#include "critical_section.h"
//#ifdef HAL_M

static void (*callback_func[8])(void);

MappingTable* nos_mappingTable = NULL;

//power port
UINT8 nos_pport_io_init(UINT8 fd)
{
	nos_uart_puts(STDOUT, "nos_pport_io_init() -->\t\t");
	if(nos_mappingTable == NULL)
	{
		nos_uart_puts(STDOUT,"\nError : table none");
		return 1;
	}
	
	switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
	case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_NONE: nos_uart_puts(STDOUT, "\npower port not used"); break;
	default : nos_uart_puts(STDOUT,"\nError : port"); return 1;
	}
	nos_uart_puts(STDOUT, "Succese\n");
	return 0;
}

UINT8 nos_pport_on(UINT8 fd)
{
	nos_uart_puts(STDOUT, "nos_pport_on() -->\t\t");
	if(nos_mappingTable == NULL)
	{
		nos_uart_puts(STDOUT,"\nError : table none");
		return 1;
	}
	if((nos_mappingTable+fd)->powPort.enable == HIGH)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : enable high port"); return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == LOW)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0) {
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : enable low port"); return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == NONE)
	{
		nos_uart_puts(STDOUT, "\npower port not used");
	}
	else 
	{
		nos_uart_puts(STDOUT,"\nError : enable");
		return 1;
	}
	nos_uart_puts(STDOUT, "Succese\n");
	return 0;
}

UINT8 nos_pport_off(UINT8 fd)
{
	nos_uart_puts(STDOUT, "nos_pport_off() -->\t\t");
	if(nos_mappingTable == NULL)
	{
		nos_uart_puts(STDOUT,"\nError : table none");
		return 1;
	}
	
	if((nos_mappingTable+fd)->powPort.enable == HIGH)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0) {
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : enable high port"); return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == LOW)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : enable low port"); return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == NONE)
	{
		nos_uart_puts(STDOUT, "\npower port not used");
	}
	else 
	{
		nos_uart_puts(STDOUT,"\nError : enable");
		return 1;
	}
	nos_uart_puts(STDOUT, "Succese\n");
	return 0;
}

UINT8 nos_pport_init(UINT8 fd)
{
	if(nos_pport_io_init(fd))
		return 1;
	if(nos_pport_off(fd))
		return 1;
	return 0;
}
//end power port
//data port
UINT8 nos_dport_io_init(UINT8 fd)
{
	nos_uart_puts(STDOUT, "nos_dport_io_init() -->\t\t");
	if(nos_mappingTable == NULL)
	{
		nos_uart_puts(STDOUT, "\nError : table none");
		return 1;
	}
	
	switch((nos_mappingTable+fd)->dataPort.type) {
	case INT_GENERAL_IN:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_CLR(DDRA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_CLR(DDRB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_CLR(DDRC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_CLR(DDRD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_CLR(DDRE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_CLR(DDRF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_CLR(DDRG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : GENERAL IN port"); return 1;
		}
		break;
	case INT_GENERAL_OUT:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : GENERAL OUT port"); return 1;
		}
		break;
	case INT_ADC:
		nos_adc_init();
		break;
	case INT_INTERRUPT:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_D: 
			switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
			case PIN_0: CLEAR_INT0_vect(); ENABLE_INT0_vect(); break;
			case PIN_1: CLEAR_INT1_vect(); ENABLE_INT1_vect(); break;
			case PIN_2: CLEAR_INT2_vect(); ENABLE_INT2_vect(); break;
			case PIN_3: CLEAR_INT3_vect(); ENABLE_INT3_vect(); break;
			default : nos_uart_puts(STDOUT,"\nError : INT(D) pin_num"); return 1;
			}
			break;
		case PORT_E: 
			switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
			case PIN_4: CLEAR_INT4_vect(); ENABLE_INT4_vect(); break;
			case PIN_5: CLEAR_INT5_vect(); ENABLE_INT5_vect(); break;
			case PIN_6: CLEAR_INT6_vect(); ENABLE_INT6_vect(); break;
			case PIN_7: CLEAR_INT7_vect(); ENABLE_INT7_vect(); break;
			default : nos_uart_puts(STDOUT,"\nError : INT(E) pin_num"); return 1;
			}
			break;
		}
		break;
	case INT_I2C:
		break;
	case INT_FREQUENCY:
		break;
	case INT_SPI:
		break;
	default : nos_uart_puts(STDOUT,"\nError : Data type"); return 1;
			
	}
	nos_uart_puts(STDOUT, "Succese\n");
	return 0;
}

UINT8 nos_dport_init(UINT8 fd)
{
	if(nos_dport_io_init(fd))
		return 1;
	return 0;
}
//end data port

//get data
UINT16 nos_get_data(UINT8 fd)
{
	UINT16 return_value;
	nos_uart_puts(STDOUT, "nos_get_data() -->\t\t");
	if(nos_mappingTable == NULL)
	{
		nos_uart_puts(STDOUT, "\nError : table none");
		return_value = 0xFFFF;
	}
	switch((nos_mappingTable+fd)->dataPort.type) {
	case INT_GENERAL_IN:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: return_value = PORTA & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_B: return_value = PORTB & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_C: return_value = PORTC & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_D: return_value = PORTD & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_E: return_value = PORTE & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_F: return_value = PORTF & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_G: return_value = PORTG & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		default : nos_uart_puts(STDOUT,"\nError : GENERAL IN port"); return_value = 0xFFFF;
		}
		break;
	case INT_GENERAL_OUT:
		nos_uart_puts(STDOUT,"\nMessage : wrong call");
		return_value = 0xFFFF;
		break;
	case INT_ADC:
		if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0) != PORT_F)
		{
			nos_uart_puts(STDOUT, "\nError : ADC port wrong");
			return_value = 0xFFFF;
		}
		return_value = nos_adc_convert(((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		
		break;
	case INT_INTERRUPT:
		break;
	case INT_I2C:
		break;
	case INT_FREQUENCY:
		break;
	case INT_SPI:
		break;
	default : nos_uart_puts(STDOUT,"\nError : Data type"); return_value = 0xFFFF;
			
	}
	nos_uart_puts(STDOUT, "Succese\n");
	return return_value;
}
//end get data
// general out
UINT8 nos_general_control(UINT8 fd, UINT8 state)
{
	nos_uart_puts(STDOUT,"nos_general_control() -->\t");
	if(state == 1)
	{
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : enable high port"); return 1;
		}
	}
	else if(state == 0)
	{
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : nos_uart_puts(STDOUT,"\nError : enable high port"); return 1;
		}
	}
	else 
	{
		nos_uart_puts(STDOUT,"\nError : enable"); 
		return 1;
	}	
	nos_uart_puts(STDOUT, "Succese\n");
	return 0;
}

//interrupt

UINT8 nos_interrupt_setting(UINT8 fd, UINT8 state)
{
	nos_uart_puts(STDOUT,"nos_interrupt_setting() -->\t");
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_D 
		&& ((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_E)
	{
		nos_uart_puts(STDOUT, "\nError : interrupt port");
		return 1;
	}

	
	switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
	case PIN_0 : 
		EICRA |= state << 0;
		break;
	case PIN_1:
		EICRA |= state << 2;
		break;
	case PIN_2:
		EICRA |= state << 4;
		break;
	case PIN_3:
		EICRA |= state << 6;
		break;
	case PIN_4 : 
		EICRB |= state << 0;
		break;
	case PIN_5:
		EICRB |= state << 2;
		break;
	case PIN_6:
		EICRB |= state << 4;
		break;
	case PIN_7:
		EICRB |= state << 6;
		break;
	default :
		nos_uart_puts(STDOUT, "\nError : state");
		return 1;
	}
	
	nos_uart_puts(STDOUT,"Success\n");
	return 0;
}

UINT8 nos_write_callback_func(UINT8 fd, void (*func)(void))
{
	nos_uart_puts(STDOUT,"nos_write_callback_func() -->\t");
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_D 
		&& ((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_E)
	{
		nos_uart_puts(STDOUT, "\nError : interrupt port");
		return 1;
	}

	callback_func[((nos_mappingTable+fd)->dataPort.port[0] & 0x0F)] = func;
	
	nos_uart_puts(STDOUT,"Success\n");
	return 0;
}


ISR(INT0_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[0])
	{
		callback_func[0]();
	}
	NOS_EXIT_ISR();
}    
ISR(INT1_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[1])
	{
		callback_func[1]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT2_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[2])
	{
		callback_func[2]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT3_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[3])
	{
		callback_func[3]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT4_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[4])
	{
		callback_func[4]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT5_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[5])
	{
		callback_func[5]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT6_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[6])
	{
		callback_func[6]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT7_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[7])
	{
		callback_func[7]();
	}
	NOS_EXIT_ISR();
}    

#endif
*/
/*  12-6
//########################################################
//
// hal.c (@ybpark)
//
//########################################################
// Copyright 2008-2014, HCI Lab
//########################################################
#include "hal.h"

#ifdef HAL_M

#ifdef UART_M
#include "uart.h"
#include "intr.h"
#include "platform.h"
#endif
#ifdef INTERRUPT_M
#include "intr.h"
#include <avr/interrupt.h>
#include "critical_section.h"
//#ifdef HAL_M

static void (*callback_func[8])(void);
#endif
MappingTable* nos_mappingTable = NULL;

//power port
UINT8 nos_pport_io_init(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
	case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
	case PORT_NONE: break;
	default : return 1;
	}
	return 0;
}

UINT8 nos_pport_on(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	if((nos_mappingTable+fd)->powPort.enable == HIGH)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == LOW)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0) {
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == NONE)
	{
	}
	else 
	{
		return 1;
	}
	return 0;
}

UINT8 nos_pport_off(UINT8 fd)
{
	if(nos_mappingTable == NULL)
	{
		return 1;
	}
	
	if((nos_mappingTable+fd)->powPort.enable == HIGH)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0) {
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == LOW)
	{
		switch((nos_mappingTable+fd)->powPort.port & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->powPort.port & 0x0F); break;
		default : return 1;
		}
	}
	else if((nos_mappingTable+fd)->powPort.enable == NONE)
	{
	}
	else 
	{
		return 1;
	}
	return 0;
}

UINT8 nos_pport_init(UINT8 fd)
{
	if(nos_pport_io_init(fd))
		return 1;
	if(nos_pport_off(fd))
		return 1;
	return 0;
}
//end power port
//data port
UINT8 nos_dport_io_init(UINT8 fd)
{
	if(nos_mappingTable == NULL)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.type) {
	case INT_GENERAL_IN:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_CLR(DDRA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_CLR(DDRB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_CLR(DDRC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_CLR(DDRD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_CLR(DDRE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_CLR(DDRF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_CLR(DDRG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : return 1;
		}
		break;
	case INT_GENERAL_OUT:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_SET(DDRA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_SET(DDRB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_SET(DDRC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_SET(DDRD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_SET(DDRE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_SET(DDRF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_SET(DDRG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : return 1;
		}
		break;
#ifdef ADC_M
	case INT_ADC:
		nos_adc_init();
		break;
#endif
#ifdef INTERRUPT_M
	case INT_INTERRUPT:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_D: 
			switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
			case PIN_0: CLEAR_INT0_vect(); ENABLE_INT0_vect(); break;
			case PIN_1: CLEAR_INT1_vect(); ENABLE_INT1_vect(); break;
			case PIN_2: CLEAR_INT2_vect(); ENABLE_INT2_vect(); break;
			case PIN_3: CLEAR_INT3_vect(); ENABLE_INT3_vect(); break;
			default : return 1;
			}
			break;
		case PORT_E: 
			switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
			case PIN_4: CLEAR_INT4_vect(); ENABLE_INT4_vect(); break;
			case PIN_5: CLEAR_INT5_vect(); ENABLE_INT5_vect(); break;
			case PIN_6: CLEAR_INT6_vect(); ENABLE_INT6_vect(); break;
			case PIN_7: CLEAR_INT7_vect(); ENABLE_INT7_vect(); break;
			default : return 1;
			}
			break;
		}
		break;
#endif
#ifdef I2C_M
	case INT_I2C:
		break;
#endif
#ifdef FREQUENCY_M
	case INT_FREQUENCY:
		break;
#endif
#ifdef SPI_M
	case INT_SPI:
		break;
	default : return 1;
#endif
	}
	return 0;
}

UINT8 nos_dport_init(UINT8 fd)
{
	if(nos_dport_io_init(fd))
		return 1;
	return 0;
}
//end data port

//get data
UINT16 nos_get_data(UINT8 fd)
{
	UINT16 return_value;
	if(nos_mappingTable == NULL)
		return_value = 0xFFFF;
	
	switch((nos_mappingTable+fd)->dataPort.type) {
	case INT_GENERAL_IN:
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: return_value = PORTA & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_B: return_value = PORTB & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_C: return_value = PORTC & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_D: return_value = PORTD & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_E: return_value = PORTE & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_F: return_value = PORTF & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		case PORT_G: return_value = PORTG & (1<<((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		default : return_value = 0xFFFF;
		}
		break;
	case INT_GENERAL_OUT:
		return_value = 0xFFFF;
		break;
#ifdef ADC_M
	case INT_ADC:
		if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0) != PORT_F)
			return_value = 0xFFFF;
		
		return_value = nos_adc_convert(((nos_mappingTable+fd)->dataPort.port[0] & 0x0F));
		
		break;
#endif
#ifdef INTERRUPT_M
	case INT_INTERRUPT:
		break;
#endif
#ifdef I2C_M
	case INT_I2C:
		break;
#endif
#ifdef FREQUENCY_M
	case INT_FREQUENCY:
		break;
#endif
#ifdef SPI_M
	case INT_SPI:
		break;
#endif
	default : return_value = 0xFFFF;
			
	}
	return return_value;
}
//end get data
// general out

UINT8 nos_general_control(UINT8 fd, UINT8 state)
{
	if(state == 1)
	{
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_SET(PORTA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_SET(PORTB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_SET(PORTC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_SET(PORTD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_SET(PORTE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_SET(PORTF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_SET(PORTG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : return 1;
		}
	}
	else if(state == 0)
	{
		switch((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)	{
		case PORT_A: _BIT_CLR(PORTA,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_B: _BIT_CLR(PORTB,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_C: _BIT_CLR(PORTC,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_D: _BIT_CLR(PORTD,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_E: _BIT_CLR(PORTE,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_F: _BIT_CLR(PORTF,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		case PORT_G: _BIT_CLR(PORTG,(nos_mappingTable+fd)->dataPort.port[0] & 0x0F); break;
		default : return 1;
		}
	}
	else 
		return 1;
	
	return 0;
}

//interrupt
#ifdef INTERRUPT_M
UINT8 nos_interrupt_setting(UINT8 fd, UINT8 state)
{
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_D 
		&& ((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_E)
		return 1;
	
	switch((nos_mappingTable+fd)->dataPort.port[0] & 0x0F) {
	case PIN_0 : 
		EICRA |= state << 0;
		break;
	case PIN_1:
		EICRA |= state << 2;
		break;
	case PIN_2:
		EICRA |= state << 4;
		break;
	case PIN_3:
		EICRA |= state << 6;
		break;
	case PIN_4 : 
		EICRB |= state << 0;
		break;
	case PIN_5:
		EICRB |= state << 2;
		break;
	case PIN_6:
		EICRB |= state << 4;
		break;
	case PIN_7:
		EICRB |= state << 6;
		break;
	default :
		return 1;
	}
	
	return 0;
}

UINT8 nos_write_callback_func(UINT8 fd, void (*func)(void))
{
	if(((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_D 
		&& ((nos_mappingTable+fd)->dataPort.port[0] & 0xF0)!= PORT_E)
		return 1;

	callback_func[((nos_mappingTable+fd)->dataPort.port[0] & 0x0F)] = func;
	
	return 0;
}


ISR(INT0_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[0])
	{
		callback_func[0]();
	}
	NOS_EXIT_ISR();
}    
ISR(INT1_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[1])
	{
		callback_func[1]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT2_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[2])
	{
		callback_func[2]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT3_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[3])
	{
		callback_func[3]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT4_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[4])
	{
		callback_func[4]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT5_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[5])
	{
		callback_func[5]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT6_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[6])
	{
		callback_func[6]();
	}
	NOS_EXIT_ISR();
}    

ISR(INT7_vect)
{
	NOS_ENTER_ISR();
	if (callback_func[7])
	{
		callback_func[7]();
	}
	NOS_EXIT_ISR();
}    
#endif

UINT8 nos_port_init(UINT8 fd)
{
	UINT8 fail_flag = FALSE;
	if(nos_pport_init(fd))
	{
#ifdef UART_M
		nos_uart_puts(STDOUT, "fd : ");
		nos_uart_putu(STDOUT, fd);
		nos_uart_puts(STDOUT, "\tPower port init fail\n");
#endif
		fail_flag = 1;
	}

	if(nos_dport_init(fd))
	{
#ifdef UART_M
		nos_uart_puts(STDOUT, "fd : ");
		nos_uart_putu(STDOUT, fd);
		nos_uart_puts(STDOUT, "\tData port init fail\n");
#endif
		fail_flag = 1;
	}

	return fail_flag;
}

#endif

*/



