//===================================================================
//
// hal_thread.h (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef HAL_THREAD_H
#define HAL_THREAD_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"

typedef UINT8 	STACK_ENTRY;	// The stack is 1 byte-contiguous array
typedef UINT8	*STACK_PTR;	// stack pointer (16 bit wide)


// push general purpose register
#define __PUSH_GPRS()				\
        __asm__ volatile (                      \
                "push   r1\n\t"                 \
                "push   r0\n\t"                 \
                "push   r2\n\t"                 \
                "push   r3\n\t"                 \
                "push   r4\n\t"                 \
                "push   r5\n\t"                 \
                "push   r6\n\t"                 \
                "push   r7\n\t"                 \
                "push   r8\n\t"                 \
                "push   r9\n\t"                 \
                "push   r10\n\t"                \
                "push   r11\n\t"                \
                "push   r12\n\t"                \
                "push   r13\n\t"                \
                "push   r14\n\t"                \
                "push   r15\n\t"                \
                "push   r16\n\t"                \
                "push   r17\n\t"                \
                "push   r18\n\t"                \
                "push   r19\n\t"                \
                "push   r20\n\t"                \
                "push   r21\n\t"                \
                "push   r22\n\t"                \
                "push   r23\n\t"                \
                "push   r24\n\t"                \
                "push   r25\n\t"                \
                "push   r26\n\t"                \
                "push   r27\n\t"                \
                "push   r28\n\t"                \
                "push   r29\n\t"                \
                "push   r30\n\t"                \
                "push   r31\n\t"                \
       )

// push status register
#define __PUSH_SREG()    			\
        __asm__ volatile (                      \
                "in     r0, __SREG__\n\t"       \
                "push   r0\n\t"                 \
       )

// the current stack pointer value is assigned to 16-bit 'addr' variable
#define __SAVE_SP(addr)  			\
        __asm__ volatile (      		\
                "in %A0, __SP_L__\n\t"  	\
                "in %B0, __SP_H__\n\t"  	\
                : "=r" (addr):			\
       )   

// pop general purpose registers
#define __POP_GPRS()     			\
        __asm__ volatile (              	\
                "pop    r31\n\t"                \
                "pop    r30\n\t"                \
                "pop    r29\n\t"                \
                "pop    r28\n\t"                \
                "pop    r27\n\t"                \
                "pop    r26\n\t"                \
                "pop    r25\n\t"                \
                "pop    r24\n\t"                \
                "pop    r23\n\t"                \
                "pop    r22\n\t"                \
                "pop    r21\n\t"                \
                "pop    r20\n\t"                \
                "pop    r19\n\t"                \
                "pop    r18\n\t"                \
                "pop    r17\n\t"                \
                "pop    r16\n\t"                \
                "pop    r15\n\t"                \
                "pop    r14\n\t"                \
                "pop    r13\n\t"                \
                "pop    r12\n\t"                \
                "pop    r11\n\t"                \
                "pop    r10\n\t"                \
                "pop    r9\n\t"         	\
                "pop    r8\n\t"         	\
                "pop    r7\n\t"         	\
                "pop    r6\n\t"         	\
                "pop    r5\n\t"         	\
                "pop    r4\n\t"         	\
                "pop    r3\n\t"         	\
                "pop    r2\n\t"         	\
                "pop    r0\n\t"         	\
                "pop    r1\n\t"         	\
       )

// pop status register
#define __POP_SREG() 				\
        __asm__ volatile (      		\
            "pop    r0\n\t"         		\
            "out    __SREG__, r0\n\t"           \
       )

// 16-bit 'addr' value is stored into stack pointer register.
// Thus, the system stack pointer is changed (context restored).
#define __LOAD_SP(addr) 			\
        __asm__ volatile ( 			\
                "out __SP_H__, %B0\n\t" 	\
                "out __SP_L__, %A0\n\t" 	\
                :: "r" (addr)			\
       )

#define NOS_THREAD_SAVE_STATE(thread) \
	{ \
		__PUSH_GPRS(); \
		__PUSH_SREG(); \
		__SAVE_SP(thread->sptr); \
	}
#define NOS_THREAD_LOAD_STATE(thread) \
	{ \
		__LOAD_SP(thread->sptr); \
		__POP_SREG(); \
		__POP_GPRS(); \
	}

#define NOS_RETURN() __asm__ volatile ("ret\n\t")

STACK_PTR nos_tcb_stack_init(void (*func)(void), STACK_PTR fos, UINT16 stack_size);

#endif // KERNEL_M
#endif // ~HAL_THREAD_H


/*#define __PUSH_ISR_SREG() 			\
        __asm__ volatile (                      \
                "in     r0, __SREG__\n\t"       \
                "sbr    r0,0x80 \n\t"   	\
                "push   r0\n\t"                 \
       )

// implement _BIT_CLR(TIMSK, TOIE0) in assembly language for naked (__attribute__) function
#define __NOS_DISABLE_SCHED_TIMER_INTERRUPT()       \
        __asm__ volatile (                      \
                "push   r18\n\t"                \
                "in     r18, 87-0x20 \n\t"      \
                "andi   r18, lo8(-2) \n\t"      \
                "out    87-0x20, r18\n\t"       \
                "pop    r18\n\t"                \
        )
       
// implement _BIT_SET(TIMSK, TOIE0)
#define __NOS_ENABLE_SCHED_TIMER_INTERRUPT()        \
        __asm__ volatile (                      \
                "push   r27\n\t"                \
                "in     r27, 87-0x20 \n\t"      \
                "ori    r27, lo8(1) \n\t"       \
                "out    87-0x20, r27\n\t"       \
                "pop    r27\n\t"                \
        )*/


