//===================================================================
//
// intr.c (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include <avr/interrupt.h>

#include "intr.h"
#include "critical_section.h"

#ifdef UART_M
#include "uart.h"
#include "platform.h"
#endif

volatile INTR_STATUS intr_status;

// Handles default interrupts (unexpected interrupts)
#ifdef UART_M
ISR(__vector_default)
{
	NOS_DISABLE_GLOBAL_INTERRUPT();
	nos_uart_puts(STDOUT, "\n\rError! : An exception (Unexpected Interrupt) has occurred. Program was halted.");
	nos_uart_puts(STDOUT, "\n\rPlease check your program if interrupt handlers are installed properly.\n");
	while (1);
}
#endif

void nos_disable_interrupt()
{
	NOS_ENTER_CRITICAL_SECTION();
	if (intr_status.cnt == 0)
	{
		intr_status.eimsk = EIMSK;
		EIMSK = 0;
		intr_status.timsk = TIMSK;
		TIMSK = 0;
		intr_status.etimsk = ETIMSK; // & (0x3F)
		ETIMSK = 0;
		//intr_status.ucsr0b = UCSR0B & (0xE0);
		//UCSR0B &= 0x1F;
		intr_status.ucsr1b = UCSR1B & (0xE0);	
		UCSR1B &= 0x1F;
		intr_status.adcsr = ADCSR & (0x08);
		ADCSR &= 0xF7;
		//intr_status.spcr = SPCR & (0x80);	
		//SPCR &= 0x7F;
		//intr_status.spmcsr = SPMCSR & (0x80);
		//SPMCSR &= 0x7F;
		//intr_status.eecr = EECR & (0x08);
		//EECR &= 0xF7;
		//intr_status.acsr = ACSR & (0x08);
		//ACSR &= 0xF7;
		//intr_status.twcr = TWCR & (0x01);
		//TWCR &= 0x0xFE;
	}
	++intr_status.cnt;
	NOS_EXIT_CRITICAL_SECTION();
}

void nos_enable_interrupt()
{
	NOS_ENTER_CRITICAL_SECTION();
	if (intr_status.cnt != 0)
	{
		--intr_status.cnt;
		if ( intr_status.cnt == 0)
		{
			EIMSK = intr_status.eimsk;
			TIMSK = intr_status.timsk;
			ETIMSK = intr_status.etimsk;
			//UCSR0B = (UCSR0B & 0x1F) |intr_status.ucsr0b;
			UCSR1B = (UCSR1B & 0x1F) |intr_status.ucsr1b;
			ADCSR = (ADCSR & 0xF7) | intr_status.adcsr;
			//SPCR = (SPCR & 0x7F) | intr_status.spcr;
			//SPMCSR = (SPMCSR & 0x7F) | intr_status.spmcsr;	
			//EECR = (EECR & 0xF7) | intr_status.eecr;
			//ACSR = (ACSR & 0xF7) | intr_status.acsr;
			//TWCR = (TWCR & 0xFE) | intr_status.twcr;
		}
	}
	NOS_EXIT_CRITICAL_SECTION();
}
