//===================================================================
//
// pwr_mgr.h	(@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef PWR_MGR_H
#define PWR_MGR_H

#include <avr/io.h>

#define NOS_IDLE			(0) 
#define NOS_ADC				(1 << SM0)
#define NOS_PWR_DOWN     	(1 << SM1)
#define NOS_PWR_SAVE		((1 << SM1) | (1 << SM0))
#define NOS_STANDBY		((1 << SM2) | (1 << SM1))
#define NOS_EXT_STANDBY	((1 << SM2) | (1 << SM1) | (1 << SM0))

#define NOS_SET_SLEEP_MODE(sleep_mode)	\
	do 			\
	{			\
		MCUCR = ( (MCUCR & ~((1 << SM2) | (1 << SM1) | (1 << SM0))) | (sleep_mode) );	\
	} 			\
	while(0)

#define NOS_SLEEP_MCU()		\
	do 			\
	{			\
		__asm__ volatile ("sleep" "\n\t" :: );	\
	} 			\
	while(0)

#define NOS_SLEEP_ENABLE()			\
	do 				\
	{				\
		_BIT_SET(MCUCR, SE);	\
	} 				\
	while(0)

#define NOS_SLEEP_DISABLE()			\
	do 				\
	{				\
	 	_BIT_CLR(MCUCR, SE);	\
	} 				\
	while(0)

#endif	// ~PWR_MGR_H


/************ For low power consumption *************/
//----------------- Analog comparator turn off (T/C1 is realated to this)
// _BIT_SET(ACSR, ACD); // note that analog comparator is turned on initially.
// _BIT_CLR(ACSR, ACIE);
//----------------- ADC turn off
// _BIT_CLR(ADCSRA, ADEN);
// _BIT_CLR(ADCSRA, ADIE);
//----------------- Watchdog turn off
// cli();
// WDTCR |= (1 << WDCE) | (1 << WDE); // WDCE bit is cleared automatically in 4 cycles.
// _BIT_CLR(WDTCR, WDE);
// sei();

