//===================================================================
//
// spi.h	(@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef SPI_H
#define SPI_H
#include "common.h"

/* SPI master/slave */
#define SPI_SLAVE	0
#define SPI_MASTER	1

/* SPI clock */
#define SPI_CLK_DIV_4	1
#define SPI_CLK_DIV_16	2
#define SPI_CLK_DIV_64	3
#define SPI_CLK_DIV_128	4
// SPI2X (in Master mode)
#define SPI_CLK_DIV_2	5
#define SPI_CLK_DIV_8	6
#define SPI_CLK_DIV_32	7
//#define SPI_CLK_DIV_64	8	

/* Sets SPI clock polarity (leading edge : rising[:0] or falling[:1]) 
			and phase (sample first?[:0] or setup first?[:1])	*/
#define SPI_MODE0	0	
#define SPI_MODE1	1
#define SPI_MODE2	2
#define SPI_MODE3	3

/* SPI data order */
//#define SPI_MSB	0
//#define SPI_LSB		1

#define SPI_INIT(is_master, clk, spi_mode) \
do { \
	SPCR = (1 << SPE) | ((spi_mode & 0x03) << CPHA) | ((clk & 0x03) << SPR0); \
	if ( is_master == SPI_MASTER ) { \
		_BIT_SET(SPCR, MSTR); \
		if (clk == SPI_CLK_DIV_2 || clk == SPI_CLK_DIV_8 || clk == SPI_CLK_DIV_32) \
			SPSR = (1 << SPI2X); \
	} \
} while (0)
   
// SPI: Low level functions
//      x = value (BYTE or WORD)
//      p = pointer to the byte array to operate on
//      c = the byte count
#define SPI_TX_REG	SPDR
#define SPI_RX_REG	SPDR
#define SPI_WAIT() \
	do { \
		while (!(SPSR & (1 << SPIF))); \
	} while (0) 

#define SPI_TX(x) \
    do { \
        SPDR = x; \
        SPI_WAIT(); \
    } while (0)

#define SPI_RX(x) \
    do { \
        SPDR = 0; \
        SPI_WAIT(); \
        x = SPDR; \
    } while (0)

#define SPI_RX_GARBAGE() \
    do { \
        SPDR = 0; \
        SPI_WAIT(); \
        SPDR; \
    } while (0)

#define SPI_TX_WORD_LE(x) \
    do { \
        SPI_TX(x); \
        SPI_TX((x) >> 8); \
    } while (0)
    
#define SPI_TX_WORD(x) \
    do { \
        SPI_TX(((UINT16)(x)) >> 8); \
        SPI_TX((UINT8)(x)); \
    } while (0)
    
#define SPI_TX_MANY(p,c) \
    do { \
        for (UINT8 spiCnt=0; spiCnt < (c); spiCnt++) { \
            SPI_TX(((UINT8*)(p))[spiCnt]); \
        } \
    } while (0)
        
#define SPI_RX_WORD_LE(x) \
    do { \
        SPDR = 0; \
        SPI_WAIT(); \
        x = SPDR; \
        SPDR = 0; \
        SPI_WAIT(); \
        x |= SPDR << 8; \
    } while (0)

#define SPI_RX_WORD(x) \
    do { \
        SPDR = 0; \
        SPI_WAIT(); \
        x = SPDR << 8; \
        SPDR = 0; \
        SPI_WAIT(); \
        x |= SPDR; \
    } while (0)
    
#define SPI_RX_MANY(p,c) \
    do { \
        for (UINT8 spiCnt=0; spiCnt < (c); spiCnt++) { \
            SPI_RX((p)[spiCnt]); \
        } \
    } while (0)

#endif // ~SPI_H

