//===================================================================
//
// timer.c (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include <avr/io.h>
#include <avr/interrupt.h>

#include "timer.h"
#include "critical_section.h"
#include "arch.h"

#ifdef TIMECHK_M
#include "time_check.h"
UINT8 local_clock_count_H;
extern void nos_local_clock_ticks(void);
#endif

void nos_timer_init()
{
#ifdef IEEE_802_15_4_MAC
	// 802.15.4 scheduling timer. TIMER2 ticks to be occurred every 320us.
	// CTC  mode, Normal port operation, prescaler = 1/64
	TCCR2 = (1<<WGM21) | (1<<CS21) | (1<<CS20);
	// Set scheduling period : _SYSTEM_CLOCK * prescaler(1/64) * 0.00032sec -1= ticks
	//8000000Hz
	if (_SYSTEM_CLOCK == 8000000ul )
	{
		OCR2 = 39;
	}
	//7372800Hz
	else 
	{
		OCR2 = 36;
	}
	CLEAR_TIMER2_COMP_vect();
	ENABLE_TIMER2_COMP_vect();
#endif

#ifdef TIMECHK_M
	// Setting for local clock
	ASSR = (1 << AS0); // user asynchronous clock : 32.768 KHz 
	TCCR0 = (1 << CS00); // prescaler : no prescaling;
	local_clock_count_H=0;
	local_clock.sec =0;
	local_clock.min =0;
	local_clock.hour =0;

	CLEAR_TIMER0_OVF_vect();
	ENABLE_TIMER0_OVF_vect();
#endif
}

#ifdef TIMECHK_M
// 32768KHz, each TCNT0 count means 30.517578125us, 256ticks --> interrupt every 7.8125ms  (*128 = 1sec)
ISR(TIMER0_OVF_vect)
{
	NOS_ENTER_ISR();
	if (++local_clock_count_H == 0)
	{
		//Local clock callback will be called every 2 sec.
		nos_local_clock_ticks();
	}
	NOS_EXIT_ISR();
}
#endif


#ifdef IEEE_802_15_4_MAC
ISR(TIMER2_COMP_vect)
{
	NOS_ENTER_ISR();
	//802.15.4 callback
	NOS_EXIT_ISR();
}
#endif

