//===================================================================
//
// uart_getc.c (@haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "uart.h"

#ifdef UART_M
#include <avr/io.h>
#include <avr/interrupt.h>
#include "critical_section.h"

volatile UINT8 uart_rx_char;
void (*rx0_callback)(UINT8) = NULL;
void (*rx1_callback)(UINT8) = NULL;

void nos_uart_getc_callback(UINT8 port_num, void (*func)(UINT8))
{
	if (port_num == 0)
	{
		rx0_callback = func;
	}
	else
	{
		rx1_callback = func;
	}
}

ISR(USART0_RX_vect)
{
	NOS_ENTER_ISR();
	uart_rx_char = UDR0;
	if (rx0_callback)
	{
		rx0_callback(uart_rx_char);
	}
	NOS_EXIT_ISR();
}

ISR(USART1_RX_vect)
{
	NOS_ENTER_ISR();
	uart_rx_char = UDR1;
	if (rx1_callback)
	{
		rx1_callback(uart_rx_char);
	}
	NOS_EXIT_ISR();
}

#endif // UART_M 
