//===================================================================
//
// uart_init.c (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include <avr/io.h>
#include "uart.h"
#include "arch.h"

#ifdef UART_M

#ifdef UART_BR_9600
	#define		_UART_BAUD_RATE		(9600ul)
#elif UART_BR_19200
	#define		_UART_BAUD_RATE		(19200ul)
#elif UART_BR_38400
	#define		_UART_BAUD_RATE		(38400ul)
#elif UART_BR_57600
	#define		_UART_BAUD_RATE		(57600ul)
#elif UART_BR_115200
	#define		_UART_BAUD_RATE		(115200ul)
#elif UART_BR_230400
	#define		_UART_BAUD_RATE		(230400ul)
#elif UART_BR_250000
	#define		_UART_BAUD_RATE		(250ul)
#elif UART_BR_500000
	#define		_UART_BAUD_RATE		(500ul)
#elif UART_BR_1000000
	#define		_UART_BAUD_RATE		(1000ul)

#endif

// UBRR = ((_SYSTEM_CLOCK/(16l*_UART_BAUD_RATE))-1) 
#define 	_UART_BAUD_RATE_L	((_SYSTEM_CLOCK/(8l*_UART_BAUD_RATE))-1)
#define 	_UART_BAUD_RATE_H	(((_SYSTEM_CLOCK/(8l*_UART_BAUD_RATE))-1) >> 8)


void nos_uart_baud_set(UINT8 port_num)
{
	if (_SYSTEM_CLOCK == 8000000ul)
	{
		switch (_UART_BAUD_RATE)
		{
			case 9600ul:
				if (port_num == 0) { UBRR0L = 103; UBRR0H = 0; return;}
				else  { UBRR1L = 103; UBRR1H = 0; return;}
			case 19200ul:
				if (port_num == 0) { UBRR0L = 51; UBRR0H = 0; return;}
				else  { UBRR1L = 51; UBRR1H = 0; return;}
			case 38400ul:
				if (port_num == 0) { UBRR0L = 25; UBRR0H = 0; return;}
				else  { UBRR1L = 25; UBRR1H = 0; return;}
			case 57600ul:
				if (port_num == 0) { UBRR0L = 16; UBRR0H = 0; return;}
				else  { UBRR1L = 16; UBRR1H = 0; return;}
			case 115200ul:
				if (port_num == 0) { UBRR0L = 8; UBRR0H = 0; return;}
				else  { UBRR1L = 8; UBRR1H = 0; return;}
			case 250ul:
				if (port_num == 0) { UBRR0L = 3; UBRR0H = 0; return;}
				else  { UBRR1L = 8; UBRR1H = 0; return;}
			case 500ul:
				if (port_num == 0) { UBRR0L = 1; UBRR0H = 0; return;}
				else  { UBRR1L = 8; UBRR1H = 0; return;}
			case 1000ul:
				if (port_num == 0) { UBRR0L = 0; UBRR0H = 0; return;}
				else  { UBRR1L = 8; UBRR1H = 0; return;}


		}
	}
	else if (_SYSTEM_CLOCK == 7372800ul)
	{
		switch (_UART_BAUD_RATE)
		{
			case 9600ul:
				if (port_num == 0) { UBRR0L = 95; UBRR0H = 0; return;}
				else  { UBRR1L = 95; UBRR1H = 0; return;}
			case 19200ul:
				if (port_num == 0) { UBRR0L = 47; UBRR0H = 0; return;}
				else  { UBRR1L = 47; UBRR1H = 0; return;}
			case 38400ul:
				if (port_num == 0) { UBRR0L = 23; UBRR0H = 0; return;}
				else  { UBRR1L = 23; UBRR1H = 0; return;}
			case 57600ul:
				if (port_num == 0) { UBRR0L = 15; UBRR0H = 0; return;}
				else  { UBRR1L = 15; UBRR1H = 0; return;}
			case 115200ul:
				if (port_num == 0) { UBRR0L = 7; UBRR0H = 0; return;}
				else  { UBRR1L = 7; UBRR1H = 0; return;}
			case 230400ul:
				if (port_num == 0) { UBRR0L = 3; UBRR0H = 0; return;}
				else  { UBRR1L = 3; UBRR1H = 0; return;}
		}	}
	else
	{
		if (port_num == 0)
		{
			UBRR0L = _UART_BAUD_RATE_L;
			UBRR0H = _UART_BAUD_RATE_H;
			return;
		}
		else
		{
			UBRR1L = _UART_BAUD_RATE_L;
			UBRR1H = _UART_BAUD_RATE_H;
			return;
		}
	}	
}


void nos_uart_init(UINT8 port_num)
{
	if ( port_num == 0 )
	{
		UCSR0A |= (1 << U2X0);
		nos_uart_baud_set(0);
		
		////////////////////////////////////  UART Register Setting 
		// UPMn (UART Parity Mode)
		// USBSn (UART Stop Bit Select) 
		// UCSZn (UART Control and Status Z, charater size)
		UCSR0C =  (0 << UPM1) | (0 << UPM0); 
		// UPM1, UPM0 		: 0 0   (no parity)
		UCSR0C |= (0 << USBS);
		// US_BS 		: 0     (1 stop bit)
		UCSR0C |= (1 << UCSZ1) | (1 << UCSZ0);
		// UCSZ2, UCSZ1, UCSZ0 	: 0 1 1 (8 bit)
		UCSR0B = (0 << UCSZ2);
		// TXEN, RXEN : enable rx/tx uart communication
		UCSR0B |=  (1 << TXEN) | (1 << RXEN);
	}
	else
	{
		UCSR1A |= (1 << U2X1);
		nos_uart_baud_set(1);

		UCSR1C =  (0 << UPM1) | (0 << UPM0); 
		UCSR1C |= (0 << USBS);
		UCSR1C |= (1 << UCSZ1) | (1 << UCSZ0);
		UCSR1B = (0 << UCSZ2);
		UCSR1B |=  (1 << TXEN) | (1 << RXEN);
	}
}
#endif
