//===================================================================
//
// adc.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include <io.h>
#include "adc.h"

#ifdef ADC_M
#include "critical_section.h"


void nos_adc_init()
{
	ADC12CTL0 |= ADC12ON; // ADC12ON : Reference on Avcc
}

// channel : XXX_SENSOR
UINT16 nos_adc_convert(UINT8 sensor_type)
{
        UINT16 adc_result;
NOS_ENTER_CRITICAL_SECTION();
	_BIT_SET(P6SEL, sensor_type);

	switch (sensor_type)
	{
		case 0 : 
			ADC12MCTL0 = INCH_0; break;
		case 1 : 
			ADC12MCTL0 = INCH_1; break;
		case 2 : 
			ADC12MCTL0 = INCH_2; break;
		case 3 : 
			ADC12MCTL0 = INCH_3; break;
		case 4 : 
			ADC12MCTL0 = INCH_4; break;
		case 5 : 
			ADC12MCTL0 = INCH_5; break;
		case 6 : 
			ADC12MCTL0 = INCH_6; break;
		case 7 : 
			ADC12MCTL0 = INCH_7; break;
	}

	ADC12CTL0 |= ADC12SC + ENC;	// sample and start conversion + (enable conversion)
	ADC12CTL0 &= ~ADC12SC;		// Sampling closed

        // wait until the conversion completes; ADC12BUSY?
	while (ADC12CTL1 & ADC12BUSY);

        // 12 bit data mode 
        adc_result = ADC12MEM0;
NOS_EXIT_CRITICAL_SECTION();
        return(adc_result);
}
#endif // ADC_M
