//===================================================================
//
// arch.h (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef ARCH_H
#define ARCH_H
#include "kconf.h"

#include "common.h"

#ifndef RAMEND
#define RAMEND 0x38FE // 10KB SRAM (0x1100 ~ 0x38FF) - because always accessed by 2bytes (should be even)
#endif

#ifdef SWAPSTK_M
#define DEFAULT_STACK_SIZE	200 // default initial stack size for registers, PC, SP, etc.
#define SYSTEM_STACK_SIZE	400// common stack size for running thread. Heap does not use this area.
#else
#define DEFAULT_STACK_SIZE	300
#define SYSTEM_STACK_SIZE	DEFAULT_STACK_SIZE
#endif

#define NOS_NOP() __asm__ volatile ("nop\n\t"::)


/*********************** PORT Definition ******************************/
// Port 3
#define SIMO0                    1 // P3.1 - Output: SIMO (Slave Input Master Output 0)
#define SOMI0                    2 // P3.2 - Input: SOMI (Slave Output Master Input 0)
#define UCLK0                     3 // P3.3 - Output: SCK (UCLK0)
#define UTXD0       	4 // P3.4 - Output: UART0 TXD
#define URXD0       	5 // P3.5 - Input:  UART0 RXD
#define UTXD1       	6 // P3.6 - Output: UART1 TXD
#define URXD1       	7 // P3.7 - Input:  UART1 RXD

// Port 5
#define SIMO1			1 // P5.1 - Output: SIMO (Slave Input Master Output 1)
#define SOMI1			2 // P5.2 - Input: SOMI (Slave Output Master Input 1)
#define UCLK1			3 // P5.3 - Output: SCK (UCLK1)

// Functions and Variables
void nos_arch_init(void);
void nos_delay_us(UINT16 usec);
void nos_delay_ms(UINT16 msec);
void nos_count_ms(UINT16 msec);

#endif // ARCH_H
