//===================================================================
//
// hal_sched.c (@haekim,@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "hal_sched.h"

#ifdef KERNEL_M
#include <io.h>
#include <signal.h>
#include "intr.h"

// Schedule period. 32ms is the maximum period.
// SCHED_TICKS = TACLK*1024(Hz) * SCHED_PEROID(ms)/1000(sec)
#ifdef SCHED_PERIOD_32
#define SCHED_TICKS		65535
#elif SCHED_PERIOD_10
#define SCHED_TICKS		20970
//SCHED_PERIOD_5
#else
#define SCHED_TICKS		10485
#endif

void (*sched_callback)(void);   // this varable indicates the scheduler is working or not.

// TimerA must use SMCLK
void nos_sched_hal_init()
{
	// TASSEL[9-8] - Timer A source select. 01:ACLK, 10:SMCLK
	// ID[7-6] - Input divider. 00:/1, 01:/2, 10:/4, 11/8
	// MC[5-4] - Mode control. 00:stop, 01:up, 10:continuous, 11:up/down
	// TACLR[2] - Timer A clear. Setting this bit resets TAR, the clock divider, the count direction (up direction sin up/down mode)
	// TAIE[1] - Timer A interrupt enable
	// TAIFG[0] - Timer A interrupt flag
	// TimerA : SMCLK(2048kHz), continuous mode
	TACCR0 = SCHED_TICKS;
	
	// scheduler interrupt callback function will be set in 'kernel.c'
	sched_callback = NULL;
}

void nos_sched_timer_start()
{
    // Timer/Counter interrupt flag register setting 
    TAR = 0;
	CLEAR_TIMERA_CCR0_vect();
	ENABLE_TIMERA_CCR0_vect();
}


// TACCR0 interrupt. Scheduling interrupt. The highest priority interrupt. 
// You must use TimerA as UP mode for precise scheduling time
wakeup interrupt (TIMERA0_VECTOR) TACCR0_ISR(void)
{
	// This ISR execute "context switch". Do not change 'nested_intr_cnt' value.
	//NOS_ENTER_ISR();
	TACCR0 += SCHED_TICKS;
	if (sched_callback)
		sched_callback();
	//NOS_EXIT_ISR();
}

#endif

