//===================================================================
//
// hal_sched.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef HAL_SCHED_H
#define HAL_SCHED_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"
#include "intr.h"

// Note that changing this value does not mean channging tick interrupt interval.
#ifdef SCHED_PERIOD_5
#define SCHED_TIMER_MS		5
#elif SCHED_PERIOD_10
#define SCHED_TIMER_MS		10
#else	// SCHED_PERIOD_32
#define SCHED_TIMER_MS		32
#endif

#define SET_KERNEL_TIMER_FLAG()	SET_TIMERA_CCR0_vect()

void nos_sched_hal_init(void);
void nos_sched_timer_start(void);

#endif // KERNEL_M
#endif // ~HAL_SCHED_H
