//===================================================================
//
// hal_thread.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "hal_thread.h"

#ifdef KERNEL_M
#include "arch.h"

// initialize stack
// This is necessary because a context should be placed in the stack when context switching.
// After context switching call, the thread with this stack will be executed starting from the function pointer (func)
STACK_PTR nos_tcb_stack_init(void (*func)(void), STACK_PTR fos, UINT16 stack_size)
{
	STACK_PTR  sptr; // stack pointer
#ifdef SWAPSTK_M
	STACK_PTR stack_bottom;
#endif
	sptr = fos + ((stack_size >> 1) - 1); // stack pointer(16bit) indicates the bottom of stack
#ifdef SWAPSTK_M
	stack_bottom = sptr;
#endif	

        // Initially we pushes the starting address of the task
        // As soon as context switching, this thread will go jump to the start address (function pointer) of this function.
        *(--sptr) = (UINT16) func;            // PC to be restored

        // Insert fills 0x00, which is not used anywhere, into the stack.
		*(--sptr) = (UINT16) 0x0000;         // r4 = 0x00; push r4
        *(--sptr) = (UINT16) 0x0000;         // r5 = 0x00; push r5
        *(--sptr) = (UINT16) 0x0000;         // r6 = 0x00; push r6
        *(--sptr) = (UINT16) 0x0000;         // r7 = 0x00; push r7
        *(--sptr) = (UINT16) 0x0000;         // r8 = 0x00; push r8
        *(--sptr) = (UINT16) 0x0000;         // r9 = 0x00; push r9
        *(--sptr) = (UINT16) 0x0000;         // r10 = 0x00; push r10
        *(--sptr) = (UINT16) 0x0000;         // r11 = 0x00; push r11
        *(--sptr) = (UINT16) 0x0000;         // r12 = 0x00; push r12
        *(--sptr) = (UINT16) 0x0000;         // r13 = 0x00; push r13
        *(--sptr) = (UINT16) 0x0000;         // r14 = 0x00; push r14
        *(--sptr) = (UINT16) 0x0000;         // r15 = 0x00; push r15

        // SREG = 0x0008; enables GIE (Global Interrupt Enable) for context switching
        *(--sptr)	= (UINT16) 0x0008;         // SREG ; push SREG

#ifdef SWAPSTK_M
	sptr = (STACK_PTR) (RAMEND - ((UINT16) stack_bottom - (UINT16) sptr));
#endif
	return ((STACK_PTR) sptr);      // eos
}
#endif
