//===================================================================
//
// hal_thread.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#ifndef HAL_THREAD_H
#define HAL_THREAD_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"

typedef UINT16   STACK_ENTRY;    // The stack is 2 byte-contiguous array
typedef UINT16   *STACK_PTR;     // stack pointer (16 bit wide)


// push general purpose register
#define __PUSH_GPRS()                           \
        __asm__ volatile (                      \
                "push   r4\n\t"                 \
                "push   r5\n\t"                 \
                "push   r6\n\t"                 \
                "push   r7\n\t"                 \
                "push   r8\n\t"                 \
                "push   r9\n\t"                 \
                "push   r10\n\t"                \
                "push   r11\n\t"                \
                "push   r12\n\t"                \
                "push   r13\n\t"                \
                "push   r14\n\t"                \
                "push   r15\n\t"                \
	)

// push status register
#define __PUSH_SREG()                           \
        __asm__ volatile (                      \
                "push   r2\n\t"                 \
       )

// the current stack pointer value is assigned to 16-bit 'addr' variable
#define __SAVE_SP(addr)                         \
        __asm__ volatile (                      \
                "mov r1, %0\n\t"           	\
                : "=r" ((UINT16) addr):         \
       )

// pop general purpose registers
#define __POP_GPRS()                            \
        __asm__ volatile (                      \
                "pop    r15\n\t"                \
                "pop    r14\n\t"                \
                "pop    r13\n\t"                \
                "pop    r12\n\t"                \
                "pop    r11\n\t"                \
                "pop    r10\n\t"                \
                "pop    r9\n\t"                 \
                "pop    r8\n\t"                 \
                "pop    r7\n\t"                 \
                "pop    r6\n\t"                 \
                "pop    r5\n\t"                 \
                "pop    r4\n\t"                 \
       )

// pop status register
#define __POP_SREG()                            \
        __asm__ volatile (                      \
            "pop    r2\n\t"                     \
       )

// 16-bit 'addr' value is stored into stack pointer register.
// Thus, the system stack pointer is changed (context restored).
#define __LOAD_SP(addr)                         \
        __asm__ volatile (                      \
                "mov %0, r1\n\t"         	\
                :: "r" ((UINT16) addr)          \
       )

#define NOS_THREAD_SAVE_STATE(thread) \
        { \
                __PUSH_GPRS(); \
                __PUSH_SREG(); \
                __SAVE_SP(thread->sptr); \
        }
#define NOS_THREAD_LOAD_STATE(thread) \
        { \
                __LOAD_SP(thread->sptr); \
                __POP_SREG(); \
                __POP_GPRS(); \
        }

#define NOS_RETURN() __asm__ volatile ("ret\n\t")


STACK_PTR nos_tcb_stack_init(void (*func)(void), STACK_PTR fos, UINT16 stack_size);

#endif // KERNEL_M
#endif // ~HAL_THREAD_H
