//===================================================================
//
// intr.h (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef INTR_H
#define INTR_H

#include <io.h>
#include "common.h"

#define NOS_DISABLE_GLOBAL_INTERRUPT() 	__asm__ __volatile__("dint"::)
#define NOS_ENABLE_GLOBAL_INTERRUPT() 	__asm__ __volatile__("eint"::)

#define ENABLE_TIMERA_OVF_vect()                do { TACTL |= TAIE; } while (0)
#define DISABLE_TIMERA_OVF_vect()               do { TACTL &= ~TAIE; } while (0)
#define CLEAR_TIMERA_OVF_vect()                 do { TACTL &= ~TAIFG; } while (0)

#define ENABLE_TIMERA_CCR0_vect()               do { TACCTL0 |= CCIE; } while (0)
#define DISABLE_TIMERA_CCR0_vect()              do { TACCTL0 &= ~CCIE; } while (0)
#define CLEAR_TIMERA_CCR0_vect()                do { TACCTL0 &= ~CCIFG; } while (0)
#define SET_TIMERA_CCR0_vect()					do { TACCTL0 |= CCIFG; } while (0)

#define ENABLE_TIMERA_CCR1_vect()                do { TACCTL1 |= CCIE; } while (0)
#define DISABLE_TIMERA_CCR1_vect()               do { TACCTL1 &= ~CCIE; } while (0)
#define CLEAR_TIMERA_CCR1_vect()                 do { TACCTL1 &= ~CCIFG; } while (0)

#define ENABLE_TIMERA_CCR2_vect()                do { TACCTL2 |= CCIE; } while (0)
#define DISABLE_TIMERA_CCR2_vect()               do { TACCTL2 &= ~CCIE; } while (0)
#define CLEAR_TIMERA_CCR2_vect()                 do { TACCTL2 &= ~CCIFG; } while (0)
#define TIMERA_CCR2_vect_IS_SET()                (TACCTL2 & CCIFG)

#define ENABLE_TIMERB_OVF_vect()                do { TBCTL |= TBIE; } while (0)
#define DISABLE_TIMERB_OVF_vect()               do { TBCTL &= ~TBIE; } while (0)
#define CLEAR_TIMERB_OVF_vect()                 do { TBCTL &= ~TBIFG; } while (0)
#define TIMERB_OVF_vect_IS_SET()                (TBCTL & TBIFG)

#define ENABLE_TIMERB_CCR2_vect()                do { TBCCTL2 |= CCIE; } while (0)
#define DISABLE_TIMERB_CCR2_vect()               do { TBCCTL2 &= ~CCIE; } while (0)
#define CLEAR_TIMERB_CCR2_vect()                 do { TBCCTL2 &= ~CCIFG; } while (0)
#define TIMERB_CCR2_vect_IS_SET()                (TBCCTL2 & CCIFG)

#define ENABLE_USART0_RX_vect()         do { IE1 |= URXIE0; } while (0)
#define DISABLE_USART0_RX_vect()        do { IE1 &= ~URXIE0; } while (0)
#define USART0_RX_vect_IS_SET()			(IE1 & URXIE0)
#define ENABLE_USART0_TX_vect()         do { IE1 |= UTXIE0; } while (0)
#define DISABLE_USART0_TX_vect()        do { IE1 &= ~UTXIE0; } while (0)

#define ENABLE_USART1_RX_vect()         do { IE2 |= URXIE1; } while (0)
#define DISABLE_USART1_RX_vect()        do { IE2 &= ~URXIE1; } while (0)
#define USART1_RX_vect_IS_SET()         (IE2 & URXIE1)
#define ENABLE_USART1_TX_vect()         do { IE2 |= UTXIE1; } while (0)
#define DISABLE_USART1_TX_vect()        do { IE2 &= ~UTXIE1; } while (0)

typedef struct _intr_status
{
	volatile UINT8 cnt;
	volatile UINT8 ie1;    // SFR interrupt enable register 1
	volatile UINT8 ie2;    // SFR interrupt enable register 2
	volatile UINT16 ta; 	// timer A interrupt
	volatile UINT16 tb;	// timer B interrupt
	volatile UINT8 i2c;    // I2C module registers
	volatile UINT8 compa;    // comparator A
	volatile UINT16 adc12;   // ADC12 interrupt enable register
//	volatile UINT16 adc10;   // ADC10 interrupt 
	volatile UINT16 dac12;   // DAC12 interrupt
}INTR_STATUS;

void nos_disable_interrupt(void);
void nos_enable_interrupt(void);

#endif	// MSP430_INTR_H
