//===================================================================
//                                      
// heap.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef HEAP_H
#define HEAP_H
#include "kconf.h"

#include "common.h"

#define XSIZE(x) ((*x)>>1)
#define FREE_P(x) (!((*x)&1)) 
#define MARK_BUSY(x) ((*x)|=1) 
#define MARK_FREE(x) ((*x)&=0xfffe) 

#define NOS_HEAP_INIT() \
	do { \
		_heap_end_addr = RAMEND - SYSTEM_STACK_SIZE; \
	} while (0)

extern UINT16 __bss_end; 
extern UINT16 _heap_end_addr;

void    *nos_malloc(UINT16 size);
void    nos_free(void *ptr);

#endif // ~HEAP_H
