//===================================================================
//                                      
// nos_malloc.c (@sheart)
//
// This code is modified from mspgcc
//===================================================================

#include "heap.h"
#include "critical_section.h"

void *nos_malloc (UINT16 size) 
{
	NOS_ENTER_CRITICAL_SECTION();
	static INT8 once = 0; 
    	UINT16 *heap_bottom; 
    	UINT16 kk = (UINT16) (&__bss_end);        /* this will possibly introduce */ 
    	UINT16 *heap_top = (UINT16 *)((kk+1)&~1);    /* 1 byte hole between .bss and heap */ 
    	INT8 f = 0; 

    	if (!once) 
    	{ 
       		once = 1; 
        	*heap_top = 0xfffe; 
    	}

	heap_bottom = (UINT16 *) _heap_end_addr;
    	heap_bottom -= 20; 
    	size = (size+1) >> 1;    // round to 2 

    	do 
	{ 
        	UINT16 xsize = XSIZE (heap_top); 
       		UINT16 * heap_next = &heap_top[xsize + 1]; 

        	if ((xsize<<1)+2 == 0) 
        	{ 
            		f = 1; 
        	}

	        if (FREE_P (heap_top)) 
        	{
	           if (f) 
            	   { 
                	xsize = heap_bottom - heap_top - 1; 
            	   } 
            	   else if (FREE_P(heap_next)) 
            	   { 
               		 *heap_top = ( (XSIZE(heap_next)<<1) + 2 == 0 ? 0xfffe : (xsize + XSIZE(heap_next) + 1)<<1 ); 
                	continue; 
            	   } 

            	   if (xsize >= size) 
            	   {
	                if (f) 
                    		heap_top[size + 1] = 0xfffe; 
                	else if (xsize != size) 
                    		heap_top[size + 1] = (xsize - size - 1) << 1; 

                	*heap_top = size << 1; 
                	MARK_BUSY (heap_top); 
					NOS_EXIT_CRITICAL_SECTION();
                	return heap_top+1;
            	    } 
	        } 

        	heap_top += xsize + 1; // move the position of heap_top
	} 
    	while (!f); 
	NOS_EXIT_CRITICAL_SECTION();
	return NULL; 
} 
