//===================================================================
//
// uart.c (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "uart.h"


#ifdef UART_M
#include "platform.h"
#include "arch.h"
#include "clock.h"

#ifdef UART_BR_9600
#define _UART_BAUD_RATE		(1)
#elif UART_BR_19200
#define _UART_BAUD_RATE		(2)
#elif UART_BR_38400
#define _UART_BAUD_RATE		(3)
#elif UART_BR_57600
#define _UART_BAUD_RATE		(4)
#elif UART_BR_115200
#define _UART_BAUD_RATE		(5)
#elif UART_BR_230400
#define _UART_BAUD_RATE		(6)
#elif UART_BR_380400
#define _UART_BAUD_RATE		(7)
#elif UART_BR_460800
#define _UART_BAUD_RATE		(8)
#elif UART_BR_921600
#define _UART_BAUD_RATE		(9)
#endif

void nos_uart_set_baudrate (UINT8 port_num, UINT16 smclk_khz);

void nos_uart_init(UINT8 port_num)
{
	//----------- UART0-----------
	if (port_num == 0)
	{
		//Use UART1 peripheral not genral I/O for P3.6, P3.7
		P3SEL |= (1 << UTXD0) | (1 << URXD0);

		//USART control register init
		//Idle-line multiprocessor protocol, UART mode, no feedback,
		// Parity disabled, 1 stop bit, 8-bit data, 1 stop bit
		U0CTL = SWRST;	//USART logic held in reset state.
		U0CTL |= CHAR;  // 8-bit data.

		// USART receive control
		U0RCTL = 0x00;

		// Clock source select
		U0TCTL = SSEL1 | SSEL0 | TXEPT;	//SMCLK, U1TXBUF is empty.	

		// Baud rate configuration
		nos_uart_set_baudrate(0, SMCLK);
		
		// module enable
		ME1 &= ~USPIE0;   // USART SPI module disable
		ME1 |= (UTXE0 | URXE0);   // USART UART module enable

		// interrupt flag initialize
		IFG1 |= UTXIFG0; // TX buffer is empty.
		IFG1 &= ~URXIFG0; // RX buffer is empty

		// USART reset released for operation
		U0CTL &= ~SWRST;
	}

	//----------- UART1-----------
	else
	{
		//Use UART1 peripheral not genral I/O for P3.6, P3.7
		P3SEL |= (1 << UTXD1) | (1 << URXD1);

		//USART control register init
		//Idle-line multiprocessor protocol, UART mode, no feedback,
		// Parity disabled, 1 stop bit, 8-bit data, 1 stop bit
		U1CTL = SWRST;	//USART logic held in reset state.
		U1CTL |= CHAR;  // 8-bit data.

		// USART receive control
		U1RCTL = 0x00;

		// Clock source select
		U1TCTL = SSEL1 | SSEL0 | TXEPT;	//SMCLK, U1TXBUF is empty.

		// Baud rate configuration
		nos_uart_set_baudrate(1, SMCLK);
		
		// module enable
		ME2 &= ~USPIE1;   // USART SPI module disable
		ME2 |= (UTXE1 | URXE1);   // USART UART module enable

		// interrupt flag initialize
		IFG2 |= UTXIFG1; // TX buffer is empty.
		IFG2 &= ~URXIFG1; // RX buffer is empty

		// USART reset released for operation
		U1CTL &= ~SWRST;
	}
	
	// for a periodic calibration
//	CLEAR_TIMERA_OVF_vect();
//	ENABLE_TIMERA_OVF_vect();

}


//If you want to use 921600 baudrate, You must set SMCLK to 2048kHz or 4096kHz
void nos_uart_set_baudrate (UINT8 port_num, UINT16 smclk_khz)
{
	// UART port 1
	if (port_num == 0)
	{
		if (smclk_khz == 1024)
		{
			switch(_UART_BAUD_RATE)
			{
				case 1: U0BR0 = 0x6D;
						U0BR1 = 0x00;
						U0MCTL = 0x22;
						return;
				case 2: U0BR0 = 0x36;
						U0BR1 = 0x00;
						U0MCTL = 0x61;
						return;
				case 3: U0BR0 = 0x1B;
						U0BR1 = 0x00;
						U0MCTL = 0x30;
						return;
				case 4: U0BR0 = 0x12;
						U0BR1 = 0x00;
						U0MCTL = 0x20;
						return;
				case 5: U0BR0 = 0x09;
						U0BR1 = 0x00;
						U0MCTL = 0x10;
						return;
				case 6: U0BR0 = 0x04;
						U0BR1 = 0x00;
						U0MCTL = 0x55;
						return;
				case 7: U0BR0 = 0x02;
						U0BR1 = 0x00;
						U0MCTL = 0x75;
						return;
				case 8: U0BR0 = 0x02;
						U0BR1 = 0x00;
						U0MCTL = 0x28;
						return;
				default: return;
			}
		}
		else if (smclk_khz == 2048)
		{
			switch(_UART_BAUD_RATE)
			{
				case 1: U0BR0 = 0xDA;
						U0BR1 = 0x00;
						U0MCTL = 0x45;
						return;
				case 2: U0BR0 = 0x6D;
						U0BR1 = 0x00;
						U0MCTL = 0x22;
						return;
				case 3: U0BR0 = 0x36;
						U0BR1 = 0x00;
						U0MCTL = 0x61;
						return;
				case 4: U0BR0 = 0x24;
						U0BR1 = 0x00;
						U0MCTL = 0x40;
						return;
				case 5: U0BR0 = 0x12;
						U0BR1 = 0x00;
						U0MCTL = 0x20;
						return;
				case 6: U0BR0 = 0x09;
						U0BR1 = 0x00;
						U0MCTL = 0x10;
						return;
				case 7: U0BR0 = 0x05;
						U0BR1 = 0x00;
						U0MCTL = 0x51;
						return;
				case 8: U0BR0 = 0x04;
						U0BR1 = 0x00;
						U0MCTL = 0x55;
						return;
				case 9: U0BR0 = 0x02;
						U0BR1 = 0x00;
						U0MCTL = 0x28;
						return;
				default: return;
			}
		}
		else	// 4096kHz
		{
			switch(_UART_BAUD_RATE)
			{
				case 1: U0BR0 = 0xB4;
						U0BR1 = 0x01;
						U0MCTL = 0x90;
						return;
				case 2: U0BR0 = 0xDA;
						U0BR1 = 0x00;
						U0MCTL = 0x45;
						return;
				case 3: U0BR0 = 0x6D;
						U0BR1 = 0x00;
						U0MCTL = 0x22;
						return;
				case 4: U0BR0 = 0x48;
						U0BR1 = 0x00;
						U0MCTL = 0x81;
						return;
				case 5: U0BR0 = 0x24;
						U0BR1 = 0x00;
						U0MCTL = 0x40;
						return;
				case 6: U0BR0 = 0x12;
						U0BR1 = 0x00;
						U0MCTL = 0x20;
						return;
				case 7: U0BR0 = 0x0B;
						U0BR1 = 0x00;
						U0MCTL = 0x10;
						return;
				case 8: U0BR0 = 0x09;
						U0BR1 = 0x00;
						U0MCTL = 0x10;
						return;
				case 9: U0BR0 = 0x04;
						U0BR1 = 0x00;
						U0MCTL = 0x55;
						return;
				default: return;
			}
		}
	}

	// UART port 1
	else
	{
		if (smclk_khz == 1024)
		{
			switch(_UART_BAUD_RATE)
			{
				case 1: U1BR0 = 0x6D;
						U1BR1 = 0x00;
						U1MCTL = 0x22;
						return;
				case 2: U1BR0 = 0x36;
						U1BR1 = 0x00;
						U1MCTL = 0x61;
						return;
				case 3: U1BR0 = 0x1B;
						U1BR1 = 0x00;
						U1MCTL = 0x30;
						return;
				case 4: U1BR0 = 0x12;
						U1BR1 = 0x00;
						U1MCTL = 0x20;
						return;
				case 5: U1BR0 = 0x09;
						U1BR1 = 0x00;
						U1MCTL = 0x10;
						return;
				case 6: U1BR0 = 0x04;
						U1BR1 = 0x00;
						U1MCTL = 0x55;
						return;
				case 7: U1BR0 = 0x02;
						U1BR1 = 0x00;
						U1MCTL = 0x75;
						return;
				case 8: U1BR0 = 0x02;
						U1BR1 = 0x00;
						U1MCTL = 0x28;
						return;
				default: return;
			}		
		}
		else if (smclk_khz == 2048)
		{
			switch(_UART_BAUD_RATE)
			{
				case 1: U1BR0 = 0xDA;
						U1BR1 = 0x00;
						U1MCTL = 0x45;
						return;
				case 2: U1BR0 = 0x6D;
						U1BR1 = 0x00;
						U1MCTL = 0x22;
						return;
				case 3: U1BR0 = 0x36;
						U1BR1 = 0x00;
						U1MCTL = 0x61;
						return;
				case 4: U1BR0 = 0x24;
						U1BR1 = 0x00;
						U1MCTL = 0x40;
						return;
				case 5: U1BR0 = 0x12;
						U1BR1 = 0x00;
						U1MCTL = 0x20;
						return;
				case 6: U1BR0 = 0x09;
						U1BR1 = 0x00;
						U1MCTL = 0x10;
						return;
				case 7: U1BR0 = 0x05;
						U1BR1 = 0x00;
						U1MCTL = 0x51;
						return;
				case 8: U1BR0 = 0x04;
						U1BR1 = 0x00;
						U1MCTL = 0x55;
						return;
				case 9: U1BR0 = 0x02;
						U1BR1 = 0x00;
						U1MCTL = 0x28;
						return;
				default: return;
			}
		}
		else	// 4096
		{
			switch(_UART_BAUD_RATE)
			{
				case 1: U1BR0 = 0xB4;
						U1BR1 = 0x01;
						U1MCTL = 0x90;
						return;
				case 2: U1BR0 = 0xDA;
						U1BR1 = 0x00;
						U1MCTL = 0x45;
						return;
				case 3: U1BR0 = 0x6D;
						U1BR1 = 0x00;
						U1MCTL = 0x22;
						return;
				case 4: U1BR0 = 0x48;
						U1BR1 = 0x00;
						U1MCTL = 0x81;
						return;
				case 5: U1BR0 = 0x24;
						U1BR1 = 0x00;
						U1MCTL = 0x40;
						return;
				case 6: U1BR0 = 0x12;
						U1BR1 = 0x00;
						U1MCTL = 0x20;
						return;
				case 7: U1BR0 = 0x0B;
						U1BR1 = 0x00;
						U1MCTL = 0x10;
						return;
				case 8: U1BR0 = 0x09;
						U1BR1 = 0x00;
						U1MCTL = 0x10;
						return;
				case 9: U1BR0 = 0x04;
						U1BR1 = 0x00;
						U1MCTL = 0x55;
						return;
				default: return;
			}
		}
	}
}

#endif // UART_M 
