//===================================================================
//
// time_check.c (@sheart, @haekim)
//      
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "time_check.h"
#ifdef TIMECHK_M

#ifdef UART_M
#include "uart.h"
UINT16 start_time, end_time;
#endif  

LOCAL_CLOCK local_clock;

// Callback by Timer0 OVF vect. This function will be called every 2sec. 
void nos_local_clock_ticks(void)
{
	UINT8 sec, min;
	UINT16 hour;
	sec = local_clock.sec;
	min = local_clock.min;
	hour = local_clock.hour; 

	sec += 2;
	if( sec == 60 )
	{
		sec = 0;
		if( ++min == 60 )
		{
			min =0;
			++hour;
		}
	}

	local_clock.sec = sec;
	local_clock.min = min;
	local_clock.hour = hour; 
}

#ifdef UART_M
// MAXIMUM measurable time : 2sec.
void nos_timechk_print()
{
	UINT16 time_cnt, time_ms, time_us;
	time_cnt = end_time - start_time;
	// 1 count unit means 30.517578125us, 32768 unit = 1sec.
	time_ms = (time_cnt/4096)*125;
	time_us = (time_cnt%4096)*30.52;
	time_ms += (time_us/1000);
	time_us %= 1000;
	uart_printf("\n%u msec %u usec\n", time_ms, time_us);
}
void nos_local_clock_print()
{
	uart_printf("\n%u Hour %u Min %u Sec\n", NOS_GET_LOCAL_CLOCK_HOUR(), NOS_GET_LOCAL_CLOCK_MIN(), NOS_GET_LOCAL_CLOCK_SEC());
}
#endif

#endif
