//===================================================================
//
// time_check.h (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef TIMECHK_H
#define TIMECHK_H
#include "kconf.h"
#ifdef TIMECHK_M

#include "common.h"
#include "timer.h"

typedef struct _local_clock{
	UINT8 sec;
	UINT8 min;
	UINT16 hour;
} LOCAL_CLOCK;
extern LOCAL_CLOCK local_clock;

#define NOS_GET_LOCAL_CLOCK_SEC()	(local_clock.sec)
#define NOS_GET_LOCAL_CLOCK_MIN()	(local_clock.min)
#define NOS_GET_LOCAL_CLOCK_HOUR()	(local_clock.hour)

#ifdef UART_M
extern UINT16 start_time, end_time;
#define NOS_TIMECHK_START() \
	do{ \
		start_time = NOS_GET_LOCAL_US_COUNTER(); \
	}while(0)

#define NOS_TIMECHK_END() \
	do{ \
		end_time = NOS_GET_LOCAL_US_COUNTER(); \
	}while(0)

void nos_timechk_print(void);
void nos_local_clock_print(void);
#endif

#endif /* * TIMECHK_M **/
#endif /* * !TIMECHK_H **/
