//===================================================================
//
// uart.h (@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef UART_H
#define UART_H
#include "kconf.h"
#ifdef UART_M
#include "common.h"

void nos_uart_init (UINT8 port_num);
void nos_uart_putc(UINT8 port_num, INT8 byte);
void nos_uart_puts(UINT8 port_num, INT8 *str);
void nos_uart_puti(UINT8 port_num, INT16 val);
void nos_uart_putu(UINT8 port_num, UINT16 val);
void uart_printf(const INT8 *msg, ...);

// This is for UART string RX from keyboard. ENTER key is used for the termination.
// Note1. This function overides "nos_uart_getc_callback". 
//              (i.e. ISR callback function set by "nos_uart_getc_callback" will not work until "nos_uart_gets" returns.)
// Note2. This function transmits the received character to the same port while receiving.
// Note3. This function eables or disables RX interrupt automatically.
void nos_uart_gets(UINT8 port_num, INT8 *str, UINT8 str_size);


//------ This is for general UART RX(getc) ----------//
#define NOS_ENABLE_UART_RX_INTR(port_num) \
        do { \
                if (port_num == 0) \
                        ENABLE_USART0_RX_vect(); \
                else \
                        ENABLE_USART1_RX_vect(); \
        } while(0)

#define NOS_DISABLE_UART_RX_INTR(port_num) \
        do { \
                if (port_num == 0) \
                        DISABLE_USART0_RX_vect(); \
                else \
                        DISABLE_USART1_RX_vect(); \
        } while(0)

void nos_uart_getc_callback(UINT8 port_num, void (*func)(UINT8));

#endif // UART_M
#endif // ~UART_H
