//===================================================================
//                                      
// uart_printf.c (@sheart)      
//                              
//===================================================================
// Copyright 2004-2010, ETRI            
//===================================================================
#include "uart.h"

#ifdef UART_M                           
#include <stdio.h>
#include <stdlib.h>
#include "platform.h"
#include "arch.h"
#include "critical_section.h"

////////// nos_uart_printf(..) currently supported format 
//                              
// d or i : signed 16bit decimal integer
// u : unsigned 16bit decimal integer
// o : unsigned 16bit octal     
// x : unsigned 16bit hexadecimal integer
// c : character        
// s : string                   
// % : '%'                      
////////////////////////////////////////////////////

extern INT8 pBuf[8];

void uart_printf(const INT8 *msg, ...)
{                               
        NOS_ENTER_CRITICAL_SECTION();
        va_list ap;
        const INT8 *p;
		float tmp;
		UINT16 temp;
        
        va_start(ap, msg);
        for (p=msg; *p; ++p)
        {
                switch(*p)
                {
                        case '%' :
                                p++;
                                if (*p == 'd' || *p == 'i')     // signed decimal integer
                                {
                                        //nos_uart_puti(STDOUT, va_arg(ap, UINT16));
                                        itoa(va_arg(ap, UINT16), pBuf, 10); // convert argument into string with a radix of 10
                                        nos_uart_puts(STDOUT, pBuf);
                                }
                                else if (*p == 'u')
                                {
                                        //nos_uart_putu(STDOUT, va_arg(ap, UINT16));
                                        utoa(va_arg(ap, UINT16), pBuf, 10); // convert argument into string with a radix of 10
                                        nos_uart_puts(STDOUT, pBuf);
                                }
                                else if (*p == 'x')     // unsigned hexadecimal integer
                                {
                                        utoa(va_arg(ap, UINT16), pBuf, 16); // convert argument into string with a radix of 16
                                        nos_uart_puts(STDOUT, pBuf);
                                }
                                else if (*p == 'o')             // signed octal
                                {
                                        utoa(va_arg(ap, UINT16), pBuf, 8); // convert argument into string with a radix of 8
                                        nos_uart_puts(STDOUT, pBuf);
                                }
                                else if (*p == 'c')     // character
                                {
                                        nos_uart_putc(STDOUT, va_arg(ap, UINT16));
                                }
                                else if (*p == 's')     // string of characters
                                {
                                        nos_uart_puts(STDOUT, va_arg(ap, INT8 *));
                                }
								else if (*p == 'f')
								{
										tmp = va_arg(ap, double);
										if(tmp<0)
											nos_uart_putc(STDOUT, '-');
										utoa((UINT16)tmp, pBuf, 10);
										nos_uart_puts(STDOUT, pBuf);
										nos_uart_putc(STDOUT,'.');
										temp = (UINT16)((tmp-(UINT16)tmp)*100);
										if(temp < 10)
										{
											nos_uart_putc(STDOUT,'0');
										}
										utoa(temp, pBuf, 10);
										nos_uart_puts(STDOUT, pBuf);
								}
                                else if (*p =='%')      // write '%' to STDOUT
                                {
                                        nos_uart_putc(STDOUT, '%');
                                }
                                else
                                {
                                        nos_uart_putc(STDOUT, *p);
                                }
                                break;

                        case '\n' :
                                nos_uart_putc(STDOUT, *p);
                                nos_uart_putc(STDOUT, '\r');
                                break;

                        default :
                                nos_uart_putc(STDOUT, *p);
                                break;
                        }
        }
        va_end(ap);
        NOS_EXIT_CRITICAL_SECTION();
        return ;
}
#endif
