//===================================================================
//
// uart_puts.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#include "uart.h"

#ifdef UART_M
#include "arch.h"
#include "critical_section.h"

void nos_uart_puts(UINT8 port_num, INT8 *str)
{
	NOS_ENTER_CRITICAL_SECTION();
    UINT8 i=0;
    while( (*(str+i) != '\0') && (i < 255) )
    {
        if ( *(str+i) == '\n' )
        {
			nos_uart_putc(port_num, '\r');
        }
        nos_uart_putc(port_num, *(str+i));
		++i;
    }
	NOS_EXIT_CRITICAL_SECTION();
}
#endif // UART_M
