//===================================================================
//
// device_driver.h	(@haekim, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef DEVICE_DRIVER_H
#define DEVICE_DRIVER_H
#include "kconf.h"
#include "typedef.h"

#define LENGTH_TDT 10

//--------------------------YB---------------------------

#define SENSOR_DRIVER_MAX	3

#define A9060	0
#define RE200B	1
#define SHT11	2

typedef struct drvPportFuncList{
	UINT8 (*power_on)(UINT8 fd);
	UINT8 (*power_off)(UINT8 fd);
}DrvPportFuncList;

typedef struct drvAdcFuncList{
	UINT8 (*init)(UINT8 fd);
	UINT16 (*read)(UINT8 fd);
}DrvAdcFuncList;

typedef struct drvIntrFuncList{
	UINT8 (*init)(UINT8 fd);
	UINT8 (*register_cb_func)(UINT8 fd, void (*func)(void));
}DrvIntrFuncList;

typedef struct drvI2cFuncList{
	UINT8 (*init)(UINT8 fd);
	float (*read)(UINT8 fd);
	UINT8 (*set_type)(UINT8 type);
}DrvI2cFuncList;

typedef struct drvFuncList{
 	INT8* drv_name;
 	DrvPportFuncList drv_func_pport;		//// Sami
	DrvAdcFuncList *drv_func_adc;
	DrvIntrFuncList *drv_func_intr;
	DrvI2cFuncList *drv_func_i2c;
}DrvFuncList;

DrvFuncList deviceDriver[SENSOR_DRIVER_MAX];

//--------------------------YB---------------------------

typedef struct {
	void (*Open)(INT16 fd);
	void (*Close)(INT16 fd);
	INT16 (*Read)(INT16 fd);
	void (*Write)(INT16 fd);
	void (*Ioctl)(INT16 fd);
} UNIFORM_IO_DRV;

typedef struct _TD
{
	INT16 index;
	INT16 type;
	INT8* device_name;
//	UNIFORM_IO_DRV func_pt ; 
	DrvFuncList func_pt ; 
}TD;

typedef struct {
	void *data;  // INT16 *data ;  ?? 
	INT16 type ; 
} Read_Data; 

typedef INT16 (*pFunc)(void) ; 

TD* Get_TD(INT8 *name) ; 
void Open(INT16 fd) ; 
void Close(INT16 fd) ; 
float Read(INT16 fd) ; 
void Write(INT16 fd, UINT8 CM);
void Ioctl(INT16 fd, INT16 funcType, INT16 Control, void (*func)(void));
void init_tdt(void) ;
INT16 device_connect(INT8 *device_name,INT8 *device_type,INT8 *device_function);
INT16 device_type_index(INT8 *device_type);
DrvFuncList device_function_list(INT8 *device_function);






#endif	// ~DEVICE_DRIVER_H

