#include "a9060.h"
#include "device_driver.h"
#ifdef A9060_M

DrvAdcFuncList a9060_func;

UINT8 a9060_func_connect(void)
{
	uart_printf(" a9060_func_connect ");
	a9060_func.init = a9060_init;
	a9060_func.read = a9060_data_read;
	
	deviceDriver[A9060].drv_name = "a9060";
	deviceDriver[A9060].drv_func_pport.power_on = a9060_power_on;
	deviceDriver[A9060].drv_func_pport.power_off = a9060_power_off;
	
	deviceDriver[A9060].drv_func_adc = &a9060_func;
	deviceDriver[A9060].drv_func_intr= NULL;
	deviceDriver[A9060].drv_func_i2c= NULL;

	
	return 0;
}
/*
UINT8 a9060_test(UINT8 fd)
{
	a9060_func.drv_func_pport.power_on(fd);
	return 0;
}
*/
UINT8 a9060_init(UINT8 fd)
{
	hal_adc_init();
	uart_printf(" a9060_init \n");	
	return hal_pport_init(fd);
}

UINT8 a9060_power_on(UINT8 fd)
{
	uart_printf(" a9060_power_on \n");
	return hal_pport_on(fd);
}

UINT8 a9060_power_off(UINT8 fd)
{
	uart_printf(" a9060_power_off \n");
	return hal_pport_off(fd);
}

UINT16 a9060_data_read(UINT8 fd)
{	
	uart_printf(" a9060_data_read \n");
	return hal_get_adc_data(fd);
}

void a9060_print_dev_name(UINT8 fd)
{
	nos_uart_puts(STDOUT, "dev_name is ");
	nos_uart_puts(STDOUT, hal_get_dev_name(fd));
	nos_uart_puts(STDOUT, "\n");

	return;
}

#endif
