#ifndef SHT11_H
#define SHT11_H
#include "kconf.h"
#ifdef SHT11_M 

#include "hal.h"
#include "arch.h"
#include "platform.h"
#include "common.h"
#include "device_driver.h"

#define COMMAND_TEMP	0
#define COMMAND_HUM		1

#define MEASURE_TEMP	0x03
#define MEASURE_HUM		0x05
#define WR_STATUS_REG	0x06
#define RD_STATUS_REG	0x07

UINT8 sht11_set_sensor_type(UINT8 type);
UINT8 sht11_get_sensor_type(void);
float sht11_read_sensor_data(UINT8 fd);
void sht11_write_status_reg(UINT8 fd, UINT8 reg);
UINT8 sht11_read_status_reg(UINT8 fd);
UINT8 sht11_init(UINT8 fd);
void sht11_data_port_init(UINT8 fd);
UINT8 sht11_power_on(UINT8 fd);
UINT8 sht11_power_off(UINT8 fd);
float sht11_data_read(UINT8 fd);
void sht11_print_dev_name(UINT8 fd);
UINT8 sht11_write_command(UINT8 fd, UINT8 command);


#endif // SHT11_M
#endif // SHT11_H

