#ifndef API_DEVICE_DRIVER_H
#define API_DEVICE_DRIVER_H

#ifdef A9060_M
#include "a9060.h"
#define a9060_init(fd) a9060_init(fd)
#define a9060_power_on(fd) a9060_power_on(fd)
#define a9060_power_off(fd) a9060_power_off(fd)
#define a9060_data_read(fd) a9060_data_read(fd)
#define a9060_print_dev_name(fd) a9060_print_dev_name(fd)
#endif

#ifdef RE200B_M   // 6 
#include "re200b.h"
#define re200b_callback_test(fd, func) re200b_callback_test(fd, func)  // Don't need
#define re200b_init(fd) re200b_init(fd)
#define re200b_power_on(fd) re200b_power_on(fd)
#define re200b_power_off(fd) re200b_power_off(fd)
#define re200b_register_callback_func(fd, func) re200b_register_callback_func(fd, func)  // IOctl    
#endif

#ifdef SHT11_M	// 7
#define sht11_funcConnectTest(fd) funcConnectTest(fd)
#define sht11_set_sensor_type(type) sht11_set_sensor_type(type)
#define sht11_get_sensor_type()	sht11_get_sensor_type()
#define sht11_read_sensor_data(fd) sht11_read_sensor_data(fd)
#define sht11_write_status_reg(fd, reg) sht11_write_status_reg(fd, reg)
#define sht11_read_status_reg(fd) sht11_read_status_reg(fd)
#define sht11_init(fd) sht11_init(fd)
#define sht11_power_on_init(fd) sht11_data_port_init(fd)
#define sht11_power_on(fd) sht11_power_on(fd)
#define sht11_power_off(fd) sht11_power_off(fd)
#define sht11_data_read(fd) sht11_data_read(fd)
#define sht11_print_dev_name(fd) sht11_print_dev_name(fd)
#endif

#endif
