//===================================================================
//
// msgq.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef MSGQ_H
#define MSGQ_H
#include "kconf.h"
#ifdef KERNEL_M
#ifdef MSGQ_M

#include "common.h"


#define MSGQ_NO_ERROR			(0)
#define MSGQ_FULL_ERROR			(1)
#define MSGQ_EMPTY_ERROR		(2)
#define MSGQ_TYPE_MATCH_ERROR		(3)
#define MSGQ_PEND_ERROR			(4)

#define MSGQ_UINT8	(1)
#define MSGQ_UINT16	(2)
#define MSGQ_UINT32	(3)

typedef struct _msgq
{
	 void *msg;  		// array of messages
	 UINT8 len;  		// length of queue
	 UINT8 type; 		// type of a message in the queue
	 UINT8 front, rear, nitem; // front, rear of the queue, the number of items in the queue
} *MSGQ;

MSGQ  nos_msgq_create(UINT8 type, UINT8 len);
void  nos_msgq_destroy(MSGQ mq);
UINT8 nos_msgq_isend(MSGQ mq, void *data);
UINT8 nos_msgq_irecv(MSGQ mq, void *data);
UINT8 nos_msgq_send(MSGQ mq, void *data);
UINT8 nos_msgq_recv(MSGQ mq, void *data);

#define MSGQ_IS_FULL(mq) (mq->nitem == mq->len)
#define MSGQ_IS_EMPTY(mq) (mq->nitem == 0)

#endif // MSGQ_M
#endif // KERNEL_M
#endif // ~MSGQ_H
