//===================================================================
//
// sem.c (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "sem.h"

#ifdef KERNEL_M
#ifdef SEM_M
#include "critical_section.h"
#include "heap.h"

#include "sched.h"
#ifndef THREAD_EXT_M
#include "threadq.h"
#else
#include "threadq_ext.h"
#endif

SEMAPHORE nos_semaphore_create(UINT8 value)
{
	SEMAPHORE s;

	s = (SEMAPHORE) nos_malloc(sizeof(struct _semaphore));
	
	s->val = value; 

	return s;
}

void nos_semaphore_destroy(SEMAPHORE sem)
{
	nos_free(sem);
}

void nos_signal(SEMAPHORE sem)
{
	NOS_ENTER_CRITICAL_SECTION();
	sem->val++;
	NOS_EXIT_CRITICAL_SECTION();

	// To give the semaphore as soon as possible to the next waiting thread for the semaphore
	nos_ctx_sw();
}

void nos_wait(SEMAPHORE sem)
{
WAIT_START:
	NOS_ENTER_CRITICAL_SECTION();
	if (sem->val > 0)
	{
		// acquire the semaphore
		sem->val--;
		NOS_EXIT_CRITICAL_SECTION();
	}
	else
	{
		// no resoure
		NOS_EXIT_CRITICAL_SECTION();
		nos_ctx_sw();

		// if the resource is released, this thread resumes from here
		// because we are not sure that the thread gets the resource
		// it should try again

		goto WAIT_START;	// need to recheck when resuming
	}

}
#endif // SEM_M
#endif // KERNEL_M
