//===================================================================
//
// taskq.h (@sheart, @haekim)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#ifndef TASKQ_H
#define TASKQ_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"

#define TASKQ_LEN          (5) // task queue length

typedef struct _task
{
	void (*func)(void);
} TASK;

typedef struct _taskq
{
	UINT8 head, tail;
	TASK task[TASKQ_LEN];
} TASKQ;

extern TASKQ taskq;

#define NOS_TASKQ_IS_EMPTY()	(taskq.head == taskq.tail)

void nos_taskq_init(void);
void nos_taskq_exe(void);
BOOL nos_taskq_reg(void (*func)(void));

#endif // KERNEL_M
#endif // ~TASKQ_H

