//===================================================================
//
// thread_join.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "thread.h"

#ifdef KERNEL_M
#include "arch.h"
#include "critical_section.h"
 #include "sched.h"

UINT8 nos_thread_join(UINT8 tid)
{

NOS_ENTER_CRITICAL_SECTION();
	if (NOS_THREAD_IS_CREATED(tid)) // the thread to be joined is alive. Wait until the thread with tid exits.
	{
		THREADQ_ENQ(tcb[tid]->waitq, _rtid);
		tcb[_rtid]->state = WAITING_STATE;
NOS_EXIT_CRITICAL_SECTION();
		nos_ctx_sw();
	}
	else // the thread to be joined already has been exited, this thread does not have to be suspend. Just proceed.
	{
NOS_EXIT_CRITICAL_SECTION();
	}
	return THREAD_NO_ERROR;
}
#endif
