//===================================================================
//
// thread_kill.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "thread.h"
#ifdef KERNEL_M

#include "critical_section.h"
#include "sched.h"
#include "heap.h"

extern THREADQ _rdy_q[PRIORITY_LEVEL_COUNT];
extern UINT8 	_ready_priority_bit;

UINT8 nos_thread_kill(UINT8 tid)
{
	UINT8 i, k;
	UINT16 ticks_diff;

	if (tid == 0) 
		return THREAD_KILL_ERROR; // The idle thread cannot die, ignore it

	if (_rtid == tid) 
		return THREAD_KILL_ERROR; // self-kill; use nos_thread_exit() instead.

NOS_ENTER_CRITICAL_SECTION();

        _BIT_CLR(_created_tid_bit, tid);

        // the waiting threads to be joined that need to be awaken at this point
        while (!THREADQ_IS_EMPTY(tcb[tid]->waitq))
        {
                THREADQ_FETCH(tcb[tid]->waitq, &i); //i is a fetched thread id
                k = tcb[i]->priority;
                tcb[i]->state = READY_STATE;
                THREADQ_ENQ(_rdy_q[k], i);
                _BIT_SET(_ready_priority_bit, k);
        }

	if (tcb[tid]->state == READY_STATE)
	{
		// dequeue the thread from the ready queue
		THREADQ_DEQ(_rdy_q[tcb[tid]->priority], tid);
        	if (THREADQ_IS_EMPTY(_rdy_q[tcb[tid]->priority]))
        	      _BIT_CLR(_ready_priority_bit, tcb[tid]->priority);
	}
	else if (tcb[tid]->state == WAITING_STATE)
	{
		_BIT_CLR(_suspended_tid_bit, tid);

		// dequeue the thread from the waiting queue
		for (i=1; i<MAX_NUM_TOTAL_THREAD; i++)
		{
			if (i != tid)
				THREADQ_DEQ(tcb[i]->waitq, tid);
		}
	}
	else if (tcb[tid]->state == SLEEPING_STATE)
	{
		_BIT_CLR(_sleep_tid_bit, tid);
		tcb[tid]->sleep_tick = 0;	

		if (_sleep_tid_bit)
                {
                	ticks_diff = _init_ticks_left - _ticks_left;
                       	_ticks_left = 65535;

                       	// for all sleeping threads, find a minimum _init_ticks_left after substracting ticks_diff
                       	for (i=1; i<MAX_NUM_TOTAL_THREAD; i++)
                        {
                         	if (NOS_THREAD_IS_SLEEP(i))
                               	{
                               		tcb[i]->sleep_tick -= ticks_diff;
                                        if (_ticks_left > tcb[i]->sleep_tick)
                                       		_ticks_left = tcb[i]->sleep_tick;
                                }
                        }
                        _init_ticks_left = _ticks_left;
                }
	}
	else ; // exit state

 	nos_free(tcb[tid]->stack_start_addr); // dealloate the stack of this thread
        nos_free(tcb[tid]); // deallocate tcb memory for this thread

	tcb[tid]->state = EXIT_STATE;

NOS_EXIT_CRITICAL_SECTION();

	return THREAD_NO_ERROR;
}
#endif
