//===================================================================
//
// thread_priority_change.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "thread.h"

#ifdef KERNEL_M
#include "arch.h"
#include "critical_section.h"
#include "sched.h"

extern THREADQ _rdy_q[PRIORITY_LEVEL_COUNT];
extern UINT8 	_ready_priority_bit;	// priority bit setting for threads, which is set for the priority of the thread when the thread becomes in ready state.

// This function should not use local variables because it is used in nos_sched_handler()
UINT8 nos_thread_priority_change(UINT8 tid, UINT8 new_priority)
{
	UINT8 i;

	// You don't need to change the priority.
	// In case of the idle thread with a priority 0, just ignore it.
	if (tcb[tid]->priority == new_priority || 
		tcb[tid]->priority > PRIORITY_LEVEL_COUNT)
		return THREAD_PRIORITY_CHANGE_ERROR;

NOS_ENTER_CRITICAL_SECTION();
	// if a thread with tid is in ready state
	if (tcb[tid]->state == READY_STATE)
	{
		i = tcb[tid]->priority;
		THREADQ_DEQ(_rdy_q[i], tid);
		if (THREADQ_IS_EMPTY(_rdy_q[i]))
			_BIT_CLR(_ready_priority_bit, i);

		THREADQ_ENQ(_rdy_q[new_priority], tid);
		tcb[tid]->priority = new_priority;
		_BIT_SET(_ready_priority_bit, new_priority);
	}
	else // the thread in other states
	{
		tcb[tid]->priority = new_priority; // just change its priority
	}
NOS_EXIT_CRITICAL_SECTION();

	return THREAD_NO_ERROR;
}
#endif
