//===================================================================
//
// thread_resume.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "thread.h"

#ifdef KERNEL_M
#include "arch.h"
#include "critical_section.h"
#include "sched.h"

extern THREADQ _rdy_q[PRIORITY_LEVEL_COUNT];
extern UINT8 	_ready_priority_bit;	// priority bit setting for threads, which is set for the priority of the thread when the thread becomes in ready state.

UINT8 nos_thread_resume(UINT8 tid)
{
	UINT8 i;

NOS_ENTER_CRITICAL_SECTION();
	if (_rtid == tid) // self-resume; this cannot happen
	{
		NOS_EXIT_CRITICAL_SECTION();
		return THREAD_RESUME_ERROR;
	}
	else
	{
		if (NOS_THREAD_IS_NOT_SUSPENDED(tid))
		{
			NOS_EXIT_CRITICAL_SECTION();
			return THREAD_RESUME_ERROR;
		}	
		else // suspended (this thread is in waiting state)
		{
			_BIT_CLR(_suspended_tid_bit, tid);

			tcb[tid]->state = READY_STATE; // make it ready
			i = tcb[tid]->priority;
			_BIT_SET(_ready_priority_bit, i);
			THREADQ_ENQ(_rdy_q[i], tid);

			NOS_EXIT_CRITICAL_SECTION();
			return THREAD_NO_ERROR;
		}
	}
}
#endif
