//===================================================================
//
// thread_suspend.c (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#include "thread.h"

#ifdef KERNEL_M
#include "arch.h"
#include "critical_section.h"
#include "sched.h"

extern THREADQ _rdy_q[PRIORITY_LEVEL_COUNT];
extern UINT8 	_ready_priority_bit;	// priority bit setting for threads, which is set for the priority of the thread when the thread becomes in ready state.

UINT8 nos_thread_suspend(UINT8 tid)
{
	UINT8 i;
	UINT16 ticks_diff;

NOS_ENTER_CRITICAL_SECTION();
	if (_rtid == tid) // self-suspend; this thread is in running state
	{
		_BIT_SET(_suspended_tid_bit, tid);
		tcb[tid]->state = WAITING_STATE;
		NOS_EXIT_CRITICAL_SECTION();
		nos_ctx_sw(); // will not come back until nos_thread_resume(tid) is executed.
	}	
	else // this thread is not in running state
	{
		_BIT_SET(_suspended_tid_bit, tid);

		if (tcb[tid]->state == READY_STATE)
		{
			tcb[tid]->state = WAITING_STATE;
			i = tcb[tid]->priority;
			THREADQ_DEQ(_rdy_q[i], tid);
			if (THREADQ_IS_EMPTY(_rdy_q[i]))
				_BIT_CLR(_ready_priority_bit, i);
		}
		if (tcb[tid]->state == SLEEPING_STATE) // no more sleeping, just suspended
		{
			tcb[tid]->state = WAITING_STATE;
			_BIT_CLR(_sleep_tid_bit, tid);
			tcb[tid]->sleep_tick = 0;

			if (_sleep_tid_bit)
			{
				ticks_diff = _init_ticks_left - _ticks_left;
				_ticks_left = 65535;

				// for all sleeping threads, find a minimum _init_ticks_left after substracting ticks_diff
                		for (i=1; i<MAX_NUM_TOTAL_THREAD; i++)
                		{
                        		if (NOS_THREAD_IS_SLEEP(i))
                        		{
                                		tcb[i]->sleep_tick -= ticks_diff;
                                		if (_ticks_left > tcb[i]->sleep_tick)
                                        		_ticks_left = tcb[i]->sleep_tick;
                        		}
                		}
				_init_ticks_left = _ticks_left;
			}
		}

		NOS_EXIT_CRITICAL_SECTION();
	}
	return THREAD_NO_ERROR;
}
#endif
