//===================================================================
//
// threadq.h (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef THREADQ_H
#define THREADQ_H
#include "kconf.h"
#ifdef KERNEL_M

#ifndef THREAD_EXT_M
#define THREADQ_ENQ(queue, tid)				\
	do							\
	{							\
		queue.q += (tid << queue.idx); 			\
		queue.idx += 3; 				\
	}							\
	while (0)

#define THREADQ_ENQ_FIRST(queue, tid)			\
	do							\
	{							\
		queue.q = queue.q << 3;				\
		queue.q += tid;					\
		queue.idx += 3					\
	}							\
	while (0)

///////////////////////////////
// 	 BIT TABLE
//
// 0000 0000 0000 0111 = 0x0007
// 0000 0000 0011 1000 = 0x0038
// 0000 0001 1100 0000 = 0x01c0
// 0000 1110 0000 0000 = 0x0e00
// 0111 0000 0000 0000 = 0x7000

// 1111 1111 1111 1000 = 0xfff8
// 1111 1111 1100 0000 = 0xffc0
// 1111 1110 0000 0000 = 0xfe00
// 1111 0000 0000 0000 = 0xf000
// 1000 0000 0000 0000 = 0x8000

#define THREADQ_DEQ(queue, tid)                                                 \
        do                                                                              \
        {                                                                               \
                if ((queue.q & 0x0007) == tid)                                          \
                {                                                                       \
                        queue.q = (queue.q & 0xfff8) >> 3;                              \
                        queue.idx -= 3;                                                 \
                }                                                                       \
                else if (((queue.q & 0x0038) >> 3) == tid)                              \
                {                                                                       \
                        queue.q = ((queue.q & 0xffc0) >> 3) + (queue.q & 0x0007);       \
                        queue.idx -= 3;                                                 \
                }                                                                       \
                else if (((queue.q & 0x01c0) >> 6) == tid)                              \
                {                                                                       \
                        queue.q = ((queue.q & 0xfe00) >> 3) + (queue.q & 0x003f);       \
                        queue.idx -= 3;                                                 \
                }                                                                       \
                else if (((queue.q & 0x0e00) >> 9) == tid)                              \
                {                                                                       \
                        queue.q = ((queue.q & 0xf000) >> 3) + (queue.q & 0x01ff);       \
                        queue.idx -= 3;                                                 \
                }                                                                       \
                else if (((queue.q & 0x7000) >> 12) == tid)                             \
                {                                                                       \
                        queue.q = (queue.q & 0x0fff);                                   \
                        queue.idx -= 3;                                                 \
                }                                                                       \
                else ;                                                                  \
        }                                                                               \
        while (0)

#define THREADQ_FETCH(queue, tid_ptr)			\
	do							\
	{							\
		*tid_ptr= queue.q & 0x0007; 			\
		queue.q = queue.q >> 3;				\
		queue.idx -= 3; 				\
	}							\
	while (0)

#define THREADQ_INIT(queue)				\
	do							\
	{							\
		queue.idx = 0;					\
		queue.q = 0;					\
	}							\
	while (0)

#define THREADQ_IS_EMPTY(queue) (queue.idx == 0)		
#define THREADQ_IS_FULL(queue)  (queue.idx == 15)
#define THREADQ_NITEM(queue) (queue.idx/3)
		
typedef struct THREADQ
{
	UINT8	idx;	// position to insert
	UINT16	q;	// 5/444/333/222/111/000
} THREADQ;
#endif // ~THREAD_EXT_M

#endif // KERNEL_M
#endif // ~THREADQ_H
