//===================================================================
//
// threadq_ext.h (@jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

///////////////////////////////
// 	 BIT TABLE
//
// 0000 0000 0000 000f 
// 0000 0000 0000 00f0
// 0000 0000 0000 0f00
// 0000 0000 0000 f000
// 0000 0000 000f 0000
// 0000 0000 0f00 0000
// 0000 0000 f000 0000
// 0000 000f 0000 0000
// 0000 00f0 0000 0000
// 0000 0f00 0000 0000
// 0000 f000 0000 0000
// 000f 0000 0000 0000
// 00f0 0000 0000 0000
// 0f00 0000 0000 0000
// f000 0000 0000 0000

#ifndef THREADQ_H
#define THREADQ_H
#include "kconf.h"
#ifdef KERNEL_M

#ifdef THREAD_EXT_M
#define THREADQ_ENQ(queue, tid)							\
	do									\
	{									\
		queue.q[queue.idx/16] += ((UINT16) tid << (queue.idx%16)); 	\
		queue.idx += 4; 						\
	}									\
	while (0)

#define THREADQ_DEQ(queue, tid)                                                 	\
        do                                                                              \
        {                                                                              	\
                if ((UINT8) (queue.q[0] & 0x000f) == tid)                                      \
                {                                                                       	   \
                        queue.q[0] = ((queue.q[0] & 0xfff0) >> 4) + ((queue.q[1] & 0x000f) << 12);   \
                        queue.q[1] = ((queue.q[1] & 0xfff0) >> 4) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[0] & 0x00f0) >> 4) == tid)                           \
                {                                                                       	\
                        queue.q[0] = ((queue.q[0] & 0xff00) >> 4) + (queue.q[0] & 0x000f) + ((queue.q[1] & 0x000f) << 12);   \
                        queue.q[1] = ((queue.q[1] & 0xfff0) >> 4) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[0] & 0x0f00) >> 8) == tid)                           \
                {                                                                       	\
                        queue.q[0] = ((queue.q[0] & 0xf000) >> 4) + (queue.q[0] & 0x00ff) + ((queue.q[1] & 0x000f) << 12);   \
                        queue.q[1] = ((queue.q[1] & 0xfff0) >> 4) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[0] & 0xf000) >> 12) == tid)                           \
                {                                                                       	\
                        queue.q[0] = (queue.q[0] & 0x0fff) + ((queue.q[1] & 0x000f) << 12);   \
                        queue.q[1] = ((queue.q[1] & 0xfff0) >> 4) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) (queue.q[1] & 0x000f) == tid)                           	\
                {                                                                       	\
                        queue.q[1] = ((queue.q[1] & 0xfff0) >> 4) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[1] & 0x00f0) >> 4) == tid)                           \
                {                                                                       	\
                        queue.q[1] = ((queue.q[1] & 0xff00) >> 4) + (queue.q[1] & 0x000f) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[1] & 0x0f00) >> 8) == tid)                           \
                {                                                                       	\
                        queue.q[1] = ((queue.q[1] & 0xf000) >> 4) + (queue.q[1] & 0x00ff) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[1] & 0xf000) >> 12) == tid)                           \
                {                                                                       	\
                        queue.q[1] = (queue.q[1] & 0x0fff) + ((queue.q[2] & 0x000f) << 12);   \
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) (queue.q[2] & 0x000f) == tid)                           \
                {                                                                       	\
                        queue.q[2] = ((queue.q[2] & 0xfff0) >> 4) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[2] & 0x00f0) >> 4) == tid)                           \
                {                                                                       	\
                        queue.q[2] = ((queue.q[2] & 0xff00) >> 4) + (queue.q[2] & 0x000f) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[2] & 0x0f00) >> 8) == tid)                           \
                {                                                                       	\
                        queue.q[2] = ((queue.q[2] & 0xf000) >> 4) + (queue.q[2] & 0x00ff) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[2] & 0xf000) >> 12) == tid)                           \
                {                                                                       	\
                        queue.q[2] = (queue.q[2] & 0x0fff) + ((queue.q[3] & 0x000f) << 12);   \
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) (queue.q[3] & 0x000f) == tid)                           \
                {                                                                       	\
                        queue.q[3] = ((queue.q[3] & 0xfff0) >> 4);    				\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[3] & 0x00f0) >> 4) == tid)                           \
                {                                                                       	\
                        queue.q[3] = ((queue.q[3] & 0xff00) >> 4) + (queue.q[3] & 0x000f);    	\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else if ((UINT8) ((queue.q[3] & 0x0f00) >> 8) == tid)                           \
                {                                                                       	\
                        queue.q[3] = ((queue.q[3] & 0xf000) >> 4) + (queue.q[3] & 0x00ff);    	\
                        queue.idx -= 4;                                                 	\
                }                                                                       	\
                else ;                                                                  	\
       }                                                                               	\
        while (0)
 
#define THREADQ_FETCH(queue, tid_ptr)			\
	do							\
	{							\
		*tid_ptr= (UINT8) (queue.q[0] & 0x000f); 	\
		queue.q[0] = (queue.q[0] >> 4) + ((queue.q[1] & 0x000f) << 12);	\
		queue.q[1] = (queue.q[1] >> 4) + ((queue.q[2] & 0x000f) << 12);	\
		queue.q[2] = (queue.q[2] >> 4) + ((queue.q[3] & 0x000f) << 12);	\
		queue.q[3] = (queue.q[3] >> 4);			\
		queue.idx -= 4; 				\
	}							\
	while (0)

#define THREADQ_INIT(queue)				\
	do							\
	{							\
		queue.idx = 0;					\
		queue.q[0] = 0;					\
		queue.q[1] = 0;					\
		queue.q[2] = 0;					\
		queue.q[3] = 0;					\
	}							\
	while (0)

#define THREADQ_IS_EMPTY(queue) (queue.idx == 0)		
#define THREADQ_IS_FULL(queue)  (queue.idx == 60)
#define THREADQ_NITEM(queue) (queue.idx/4)
		
typedef struct THREADQ
{
	UINT8	idx;	// position to insert
	UINT16	q[4];	// q[0][1][2][3]
} THREADQ;

#endif // ~THREAD_EXT_M

#endif // KERNEL_M
#endif // ~THREADQ_H
