//===================================================================
//
// user_timer.h (@sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================

#ifndef USER_TIMER_H
#define USER_TIMER_H
#include "kconf.h"
#ifdef KERNEL_M

#include "common.h"
#include "hal_sched.h"

#define TIMER_ONE_SHOT			(0)
#define TIMER_PERIODIC			(1)
#define MAX_NUM_TOTAL_TIMER		(8) // the number of timers available for users

#define TIMER_CREATE_ERROR		(0xFF)
#define TIMER_NO_ERROR			(0)
#define TIMER_ACTIVATE_ERROR	(3)
#define TIMER_DEACTIVATE_ERROR	(4)
#define TIMER_DESTROY_ERROR		(5)


typedef struct _user_timer
{
	void 	(*func)(void);		// function pointer
	UINT8	tmid;			// timer id
	UINT16  init_tick;		// the number of ticks to be expired for timer
	UINT16  timer_tick;		// the number of ticks to be expired for timer
	UINT8	opt;			// option
	
}USER_TIMER;

UINT8	_created_timer_bit;	// for timers
UINT8	_activated_timer_bit;	// for timers
UINT8	_expired_timer_bit;	// for timers
UINT16  _init_timer_ticks_left; // timer ticks left until first wake-up (initially setting)
UINT16  _timer_ticks_left; // timer ticks left currently

#define NOS_TIMER_IS_CREATED(tmid)		(_created_timer_bit & (1 << tmid))
#define NOS_TIMER_IS_ACTIVATED(tmid)		(_activated_timer_bit & (1 << tmid))
#define NOS_TIMER_IS_EXPIRED(tmid)		(_expired_timer_bit & (1 << tmid))
#define NOS_TIMER_IS_NOT_CREATED(tmid)		(~_created_timer_bit & (1 << tmid))
#define NOS_TIMER_IS_NOT_ACTIVATED(tmid)	(~_activated_timer_bit & (1 << tmid))
#define NOS_TIMER_IS_NOT_EXPIRED(tmid)		(~_expired_timer_bit & (1 << tmid))

UINT8 nos_timer_create(void (*func)(void), UINT16 ticks, UINT8 opt);
UINT8 nos_timer_destroy(UINT8 tmid);
UINT8 nos_timer_activate(UINT8 tmid);
UINT8 nos_timer_deactivate(UINT8 tmid);
void nos_timer_exe(void);

#define nos_timer_create_ms(func, ms, opt)         nos_timer_create(func, (ms-1+SCHED_TIMER_MS)/SCHED_TIMER_MS, opt)
#define nos_timer_create_sec(func, sec, opt)       nos_timer_create(func, (1000*sec-1+SCHED_TIMER_MS)/SCHED_TIMER_MS, opt)

#endif // KERNEL_M
#endif // ~USER_TIMER_H
