//===================================================================
//
// nano_mac.h (@haekim, @jun361, @sheart)
//
//===================================================================
// Copyright 2004-2010, ETRI
//===================================================================
#ifndef NANO_MAC_H
#define NANO_MAC_H
#include "kconf.h"
#ifdef NANO_MAC_M

#include "common.h"
#include "cc2420.h"

#define NMAC_MAX_TX_TRIALS	(3) // Tx trials when Ack is not received.
#define NMAC_RXQ_LEN		(4)	//maximum RX queue length. 121bytes per entity.

// Packet overhead on intra PAN mode. ((frame control field, sequence number, destination PAN id, destination address, source address) + (frame check sequence))
#define NMAC_FRAME_OVERHEAD_SIZE ((2+1+2+2+2)+(2))	// 11 byte

// MAC frame length field (1 byte) in PHY is also overhead. 
#define NMAC_MAX_PAYLOAD_SIZE (CC2420_RXFIFO_SIZE - NMAC_FRAME_OVERHEAD_SIZE - 1) // 116byte

// Tx information in Nano-MAC
typedef struct _nmac_tx_info
{
	UINT16  dest_addr;
#ifdef ROUTING_M
	UINT8 routing_header_length;
	void  *routing_header_ptr;
#endif
	UINT8  payload_length; // length of frame payload (frame:MAC, packet:Routing)
	void  *payload_ptr;
} NMAC_TX_INFO;

// Rx information in Nano-MAC
typedef struct _nmac_rx_info
{
	UINT16 	src_addr;	// source address
	INT8 	rssi;		//Received Signal Strength Indicator
	UINT8	corr; 		//Correlation value (unsigned 7bit) for LQI	
	UINT8 	payload_length; 		// length of frame payload (frame:MAC, packet:Routing)
	void*	payload_ptr;
} NMAC_RX_INFO;

void nmac_init(UINT8 channel, UINT16 panid, UINT16 myaddr);
void nmac_set_tx_power(UINT8 level);
void nmac_rx_on(void);
void nmac_rx_off(void);
void nmac_set_rx_cb(void (*func)(void));
BOOL nmac_rx(NMAC_RX_INFO* nmac_rx_info_ptr);
BOOL nmac_tx(NMAC_TX_INFO* nmac_tx_info_ptr);
BOOL nmac_tx_noack (NMAC_TX_INFO* nmac_tx_info_ptr);

//--------- for testing (restricton in RX range) ---------------
// Note that we cannot stop TX auto-ack even if source address is not permitted
#ifdef DEMO_MAC_M
void nmac_set_rx_range(UINT16 min_addr, UINT16 max_addr);
#endif 

#endif // NANO_MAC_M
#endif // ~NANO_MAC_H
